/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.higgs.core.ConfigUtil;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpResponse;
import io.higgs.http.server.HttpStatus;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.protocol.mediaTypeDecoders.JsonDecoder;
import io.higgs.http.server.resource.MediaType;
import io.higgs.http.server.transformers.BaseTransformer;
import io.higgs.http.server.transformers.JsonResponseError;
import io.higgs.http.server.transformers.conf.JsonConfig;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URI;
import java.net.URISyntaxException;

public class JsonTransformer
extends BaseTransformer {
    protected JsonConfig conf = (JsonConfig)ConfigUtil.loadYaml((String)"json_config.yml", JsonConfig.class);

    public JsonTransformer() {
        this.setPriority(this.conf.priority);
        this.addSupportedTypes(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
    }

    public boolean canTransform(Object response, HttpRequest request, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        return method != null && this.pathIsJson(request.getUri()) || super.canTransform(response, request, mediaType, method, ctx);
    }

    private boolean pathIsJson(String uri) {
        if (uri == null || uri.isEmpty()) {
            return false;
        }
        try {
            String path = new URI(uri).getPath();
            if (path == null || path.isEmpty()) {
                return false;
            }
            if (path.endsWith(".json")) {
                return true;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return false;
    }

    public void transform(Object response, HttpRequest request, HttpResponse res, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        byte[] data = null;
        if (response == null) {
            data = "{}".getBytes();
        } else {
            if (this.isError(response)) {
                response = this.convertErrorToResponseObject(res, (Throwable)response);
            }
            try {
                data = JsonDecoder.mapper.writeValueAsBytes(response);
            }
            catch (JsonProcessingException e) {
                this.log.warn("Unable to transform response to JSON", (Throwable)e);
                res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        this.setResponseContent(res, data);
    }

    protected Object convertErrorToResponseObject(HttpResponse res, Throwable response) {
        this.determineErrorStatus(res, response);
        if (response instanceof JsonResponseError) {
            JsonResponseError je = (JsonResponseError)((Object)response);
            res.setStatus(HttpResponseStatus.valueOf((int)je.getResponse().getStatus()));
            return je.getContent();
        }
        this.log.warn("Unable to convert exception to response", response);
        return "{}";
    }

    public JsonTransformer instance() {
        return this;
    }
}

