/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers;

import io.higgs.core.ConfigUtil;
import io.higgs.core.FileUtil;
import io.higgs.core.ResolvedFile;
import io.higgs.core.reflect.dependency.DependencyProvider;
import io.higgs.core.reflect.dependency.Injector;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpResponse;
import io.higgs.http.server.ManagedWriter;
import io.higgs.http.server.config.HttpConfig;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.resource.MediaType;
import io.higgs.http.server.transformers.BaseTransformer;
import io.higgs.http.server.transformers.ResponseTransformer;
import io.higgs.http.server.transformers.StaticFileWriter;
import io.higgs.http.server.transformers.conf.FilesConfig;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.WebApplicationException;

public class StaticFileTransformer
extends BaseTransformer {
    private static Map<String, String> formats = new ConcurrentHashMap<String, String>();
    protected HttpConfig config;
    protected Path base;
    private FilesConfig conf;

    public StaticFileTransformer() {
        Injector.inject((Object)((Object)this), (DependencyProvider)DependencyProvider.global());
        this.conf = (FilesConfig)ConfigUtil.loadYaml((String)"static_file_config.yml", FilesConfig.class);
        this.base = Paths.get(this.config.public_directory, new String[0]);
        DiskFileUpload.deleteOnExitTemporaryFile = this.conf.delete_temp_on_exit;
        DiskFileUpload.baseDirectory = this.conf.temp_directory;
        DiskAttribute.deleteOnExitTemporaryFile = this.conf.delete_temp_on_exit;
        DiskAttribute.baseDirectory = this.conf.temp_directory;
        Map<String, String> textFormats = this.conf.custom_mime_types;
        for (String commaSeparatedExtensions : textFormats.keySet()) {
            String[] extensions = commaSeparatedExtensions.split(",");
            String contentType = textFormats.get(commaSeparatedExtensions);
            for (String extension : extensions) {
                formats.put(extension, contentType);
            }
        }
        this.setPriority(this.conf.priority);
    }

    public boolean canTransform(Object response, HttpRequest request, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        return this.isStaticFileResponse(response);
    }

    public void transform(Object response, HttpRequest request, HttpResponse res, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        if (response != null) {
            if (response instanceof File) {
                response = FileUtil.resolve((Path)this.base, (File)((File)response));
            } else if (response instanceof Path) {
                response = FileUtil.resolve((Path)this.base, (Path)((Path)response));
            } else if (response instanceof WebApplicationException) {
                WebApplicationException ex = (WebApplicationException)response;
                res.setStatus(HttpResponseStatus.valueOf((int)ex.getResponse().getStatus()));
                if (ex.getMessage() != null && !ex.getMessage().isEmpty()) {
                    byte[] msg = ex.getMessage().getBytes();
                    ByteBuf buf = ctx.alloc().heapBuffer(msg.length);
                    res.resetContent(buf);
                }
            }
            if (response instanceof ResolvedFile) {
                this.writeResponseFromStream((ResolvedFile)response, res, request, mediaType, method, ctx);
            } else {
                res.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
                if (this.isError(response)) {
                    this.log.warn("Unexpected error to static file transformer", response);
                } else {
                    this.log.warn(String.format("Expecting an input stream or file,%s received", response.getClass().getName()));
                }
            }
        }
    }

    private void writeResponseFromStream(ResolvedFile response, HttpResponse res, HttpRequest request, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        res.setManagedWriter((ManagedWriter)new StaticFileWriter(ctx, res, response, request, formats, this.conf));
    }

    public ResponseTransformer instance() {
        return new StaticFileTransformer();
    }
}

