/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import java.io.InputStream;

public class ChunkedFileWriter
implements ChunkedInput<ByteBuf> {
    protected InputStream stream;
    protected int chunkSize;

    public ChunkedFileWriter(InputStream in, int chunkSize) {
        this.stream = in;
        this.chunkSize = chunkSize;
    }

    public boolean isEndOfInput() throws Exception {
        return this.stream.available() == 0;
    }

    public void close() throws Exception {
        this.stream.close();
    }

    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        ByteBuf buf = ctx.alloc().heapBuffer(this.chunkSize);
        int read = this.stream.read(buf.array());
        buf.writerIndex(read);
        return buf;
    }
}

