/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers;

import io.higgs.core.reflect.ReflectionUtil;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpResponse;
import io.higgs.http.server.HttpStatus;
import io.higgs.http.server.config.TemplateConfig;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.resource.MediaType;
import io.higgs.http.server.transformers.BaseTransformer;
import io.higgs.http.server.transformers.thymeleaf.Thymeleaf;
import io.higgs.http.server.transformers.thymeleaf.WebContext;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;

public class ThymeleafTransformer
extends BaseTransformer {
    protected TemplateConfig config;
    protected Thymeleaf tl;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public ThymeleafTransformer(TemplateConfig config, boolean ignoreConfigPrefixAndSuffix) {
        this.config = config;
        this.tl = new Thymeleaf(this.config, ignoreConfigPrefixAndSuffix);
    }

    public ThymeleafTransformer(TemplateConfig template_config) {
        this(template_config, false);
    }

    @Override
    public boolean canTransform(Object response, HttpRequest request, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        if (!method.hasTemplate()) {
            return false;
        }
        if (request.getMediaTypes().isEmpty()) {
            return true;
        }
        for (MediaType type : request.getMediaTypes()) {
            if (!type.isCompatible(MediaType.WILDCARD_TYPE) && !type.isCompatible(MediaType.TEXT_HTML_TYPE) && !type.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE) && !type.isCompatible(MediaType.APPLICATION_XHTML_XML_TYPE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void transform(Object response, HttpRequest request, HttpResponse httpResponse, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        WebContext webContext = new WebContext();
        String[] fragements = method.getFragments();
        String template2 = method.getTemplate();
        if (fragements.length > 0) {
            template2 = this.tl.getFullTemplate(template2, fragements);
        }
        this.transform(webContext, template2, response, request, httpResponse, mediaType, method, ctx, null);
    }

    @Override
    public ThymeleafTransformer instance() {
        return new ThymeleafTransformer(this.config, false);
    }

    public void transform(WebContext webContext, String templateName, Object response, HttpRequest request, HttpResponse res, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx, HttpResponseStatus status) {
        byte[] data = null;
        try {
            if (request != null) {
                if (this.config.determine_language_from_accept_header) {
                    try {
                        webContext.setLocale(Locale.forLanguageTag(request.headers().get("Accept-Language")));
                    }
                    catch (Throwable t) {
                        this.log.warn("Unable to set locale from accept header");
                    }
                }
                this.populateContext(webContext, response, request, method);
            }
            String content = this.tl.getTemplateEngine().process(templateName, (IContext)webContext);
            data = content.getBytes(Charset.forName(this.config.character_encoding));
        }
        catch (Throwable e) {
            this.log.warn("Unable to transform response to HTML using Thymeleaf transformer", e);
            res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (data != null) {
            res.setStatus(status == null ? HttpStatus.OK : status);
            res.content().writeBytes(data);
            HttpHeaders.setContentLength((HttpMessage)res, (long)data.length);
        }
    }

    private void populateContext(WebContext ctx, Object response, HttpRequest request, HttpMethod method) {
        ctx.setVariable("_query", request.getQueryParams());
        ctx.setVariable("_form", request.getFormParam());
        ctx.setVariable("_files", request.getFormFiles());
        ctx.setVariable("_session", request.getSession());
        ctx.setVariable("_cookies", request.getCookies());
        ctx.setVariable("_request", (Object)request);
        ctx.setVariable("_response", response);
        if (method != null) {
            ctx.setVariable("_validation", method.getValidationResult());
        }
        if (response instanceof Map || response != null && !ReflectionUtil.isNumeric(response.getClass()) && !(response instanceof Collection)) {
            if (response instanceof Map && this.config.convert_map_responses_to_key_value_pairs) {
                ctx.setVariables((Map)response);
            } else if (this.config.convert_pojo_responses_to_key_value_pairs) {
                Set fields = ReflectionUtil.getAllFields(new HashSet(), response.getClass(), (int)10);
                for (Field field : fields) {
                    try {
                        field.setAccessible(true);
                        ctx.setVariable(field.getName(), field.get(response));
                    }
                    catch (IllegalAccessException e) {
                        this.log.warn(String.format("Unable to set template variable %s", field.getName()), (Throwable)e);
                    }
                }
            }
        }
    }

    public TemplateConfig getConfig() {
        return this.config;
    }

    public TemplateEngine getTemplateEngine() {
        return this.tl.getTemplateEngine();
    }

    public int priority() {
        return 1;
    }
}

