/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers;

import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpResponse;
import io.higgs.http.server.HttpStatus;
import io.higgs.http.server.ManagedWriter;
import io.higgs.http.server.StaticFileMethod;
import io.higgs.http.server.config.HttpConfig;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileWriter
implements ManagedWriter {
    protected static final Logger log = LoggerFactory.getLogger(StaticFileWriter.class);
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;
    private static final Pattern ALLOWED_FILE_NAME = Pattern.compile("[A-Za-z0-9][-_A-Za-z0-9\\.]*");
    private final File file;
    private final ChannelHandlerContext ctx;
    private final io.netty.handler.codec.http.HttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    private final HttpResponse higgsPreparedResponse;
    private final HttpRequest request;
    private final HttpConfig conf;
    private File base;
    public boolean done;

    public StaticFileWriter(ChannelHandlerContext ctx, HttpResponse resIgnored, File file, HttpRequest request, Map<String, String> formats, HttpConfig conf) {
        this.base = StaticFileMethod.baseUri(conf.files.public_directory);
        this.conf = conf;
        this.ctx = ctx;
        this.file = file;
        this.request = request;
        this.higgsPreparedResponse = resIgnored;
        if (file.isDirectory()) {
            this.sendListing();
            return;
        }
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        String contentType = mimeTypesMap.getContentType(file.getPath());
        for (String ext : formats.keySet()) {
            if (!file.getName().endsWith(ext)) continue;
            contentType = formats.get(ext);
            break;
        }
        this.res.headers().set("Content-Type", (Object)contentType);
        this.setDateAndCacheHeaders();
        if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
            this.res.headers().set("Connection", (Object)"keep-alive");
        }
    }

    @Override
    public ChannelFuture doWrite() {
        ChannelFuture writeFuture;
        if (this.file.isDirectory()) {
            return this.ctx.writeAndFlush((Object)this.higgsPreparedResponse);
        }
        try {
            long fileLength;
            RandomAccessFile raf;
            try {
                raf = new RandomAccessFile(this.file, "r");
            }
            catch (FileNotFoundException fnfe) {
                this.res.setStatus(HttpStatus.NOT_FOUND);
                return this.ctx.writeAndFlush((Object)this.res);
            }
            try {
                fileLength = raf.length();
            }
            catch (IOException e) {
                log.warn("Error reading file", (Throwable)e);
                this.res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
                return this.ctx.writeAndFlush((Object)this.res);
            }
            this.res.setStatus(HttpStatus.OK);
            HttpHeaders.setContentLength((HttpMessage)this.res, (long)fileLength);
            this.ctx.write((Object)this.res);
            writeFuture = this.ctx.write((Object)new ChunkedFile(raf, 0L, fileLength, this.conf.files.chunk_size), (ChannelPromise)this.ctx.newProgressivePromise());
            writeFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

                public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                }

                public void operationComplete(ChannelProgressiveFuture future) throws Exception {
                    StaticFileWriter.this.done = true;
                }
            });
            ChannelFuture lastWrite = this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            if (!HttpHeaders.isKeepAlive((HttpMessage)this.request)) {
                lastWrite.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (IOException e) {
            this.done = true;
            log.warn("Error writing chunk", (Throwable)e);
            this.res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            writeFuture = this.ctx.writeAndFlush((Object)this.res);
        }
        return writeFuture;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    private void setDateAndCacheHeaders() {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        this.res.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 60);
        this.res.headers().set("Expires", (Object)dateFormatter.format(time.getTime()));
        this.res.headers().set("Cache-Control", (Object)"private, max-age=60");
        this.res.headers().set("Last-Modified", (Object)dateFormatter.format(new Date(this.file.lastModified())));
    }

    private void sendListing() {
        StringBuilder buf = new StringBuilder();
        String dirPath = this.file.getPath();
        dirPath = dirPath.replace(this.base.getPath(), "");
        buf.append("<!DOCTYPE html>\r\n");
        buf.append("<html><head><title>");
        buf.append("Listing of: ");
        buf.append(dirPath);
        buf.append("</title></head><body>\r\n");
        buf.append("<h3>Listing of: ");
        buf.append(dirPath);
        buf.append("</h3>\r\n");
        buf.append("<ul>");
        buf.append("<li><a href=\"../\">..</a></li>\r\n");
        for (File f : this.file.listFiles()) {
            String name;
            if (f.isHidden() || !f.canRead() || !ALLOWED_FILE_NAME.matcher(name = f.getName()).matches()) continue;
            buf.append("<li><a href=\"");
            buf.append(dirPath + "/" + name);
            buf.append("\">");
            buf.append(name);
            buf.append("</a></li>\r\n");
        }
        buf.append("</ul></body></html>\r\n");
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)buf, (Charset)CharsetUtil.UTF_8);
        this.higgsPreparedResponse.content().writeBytes(buffer);
        this.higgsPreparedResponse.headers().set("Content-Type", (Object)"text/html; charset=UTF-8");
        HttpHeaders.setContentLength((HttpMessage)this.res, (long)buffer.writerIndex());
        HttpHeaders.setKeepAlive((HttpMessage)this.res, (boolean)false);
    }
}

