/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers;

import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpResponse;
import io.higgs.http.server.config.HttpConfig;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.protocol.HttpProtocolConfiguration;
import io.higgs.http.server.resource.MediaType;
import io.higgs.http.server.transformers.BaseTransformer;
import io.higgs.http.server.transformers.JarFile;
import io.higgs.http.server.transformers.ResponseTransformer;
import io.higgs.http.server.transformers.StaticFileWriter;
import io.higgs.http.server.transformers.ThymeleafTransformer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class StaticFileTransformer
extends BaseTransformer {
    private static Map<String, String> formats = new ConcurrentHashMap<String, String>();
    private final HttpProtocolConfiguration config;
    private final HttpConfig conf;
    private Pattern[] tlExtensions;

    public StaticFileTransformer(HttpProtocolConfiguration configuration) {
        this.config = configuration;
        this.conf = (HttpConfig)configuration.getServer().getConfig();
        Map<String, String> textFormats = this.conf.files.custom_mime_types;
        for (String commaSeparatedExtensions : textFormats.keySet()) {
            String[] extensions = commaSeparatedExtensions.split(",");
            String contentType = textFormats.get(commaSeparatedExtensions);
            for (String extension : extensions) {
                formats.put(extension, contentType);
            }
        }
        String[] tmp = this.conf.template_config.auto_parse_extensions.split(",");
        this.tlExtensions = new Pattern[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            String ext = tmp[i];
            if (ext == null || ext.isEmpty()) continue;
            this.tlExtensions[i] = Pattern.compile(ext);
        }
    }

    @Override
    public boolean canTransform(Object response, HttpRequest request, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        return response != null && (response instanceof File || response instanceof JarFile);
    }

    @Override
    public void transform(Object response, HttpRequest request, HttpResponse res, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        for (Pattern extensionPattern : this.tlExtensions) {
            String fileName;
            String string = fileName = response instanceof File ? ((File)response).getName() : ((JarFile)response).getEntry().getName();
            if (!extensionPattern.matcher(fileName).matches()) continue;
            this.parseTemplate(response, request, res, mediaType, method, ctx);
        }
        if (response != null) {
            if (response instanceof InputStream) {
                this.writeResponseFromStream((InputStream)response, res, request, mediaType, method, ctx);
            } else if (response instanceof File) {
                this.writeResponseFromFile((File)response, res, request, mediaType, method, ctx, res.content());
            } else {
                res.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
                this.log.warn(String.format("Expecting an input stream or file,%s received", response.getClass().getName()));
            }
        }
    }

    private void parseTemplate(Object response, HttpRequest request, HttpResponse httpResponse, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        ThymeleafTransformer transformer = new ThymeleafTransformer(this.conf.template_config, true);
        Path path = null;
        try {
            Object file;
            if (response instanceof JarFile) {
                file = (JarFile)response;
                path = Files.createTempFile("hs3-thymleaf" + ((JarFile)file).getEntry().getName(), "tmpTpl", new FileAttribute[0]);
                FileOutputStream out = new FileOutputStream(path.toFile());
                while (((JarFile)file).getInputStream().available() > 0) {
                    byte[] arr = new byte[((JarFile)file).getInputStream().available()];
                    ((JarFile)file).getInputStream().read(arr);
                    out.write(arr);
                }
            } else {
                file = (File)response;
                path = ((File)file).toPath();
            }
            String name = path.toString();
            method.setTemplate(name);
            transformer.transform(response, request, httpResponse, mediaType, method, ctx);
        }
        catch (IOException e) {
            this.log.warn(String.format("Error passing static file through Thymeleaf Path:%s", path), (Throwable)e);
            httpResponse.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void writeResponseFromStream(InputStream response, HttpResponse res, HttpRequest request, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        this.readEntireStream(response, res);
    }

    private void readEntireStream(InputStream response, HttpResponse res) {
        try {
            int b;
            while ((b = response.read()) != -1) {
                res.content().writeByte(b);
            }
        }
        catch (IOException e) {
            this.log.warn("Error reading file input stream", (Throwable)e);
        }
    }

    private void writeResponseFromFile(File file, HttpResponse res, HttpRequest request, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx, ByteBuf buffer) {
        res.setManagedWriter(new StaticFileWriter(ctx, res, file, request, formats, this.conf));
    }

    @Override
    public ResponseTransformer instance() {
        return new StaticFileTransformer(this.config);
    }

    public int priority() {
        return -1;
    }
}

