/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpResponse;
import io.higgs.http.server.HttpStatus;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.resource.MediaType;
import io.higgs.http.server.transformers.BaseTransformer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTransformer
extends BaseTransformer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ObjectMapper mapper = new ObjectMapper();

    public JsonTransformer() {
        this.mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, true);
        VisibilityChecker visibilityChecker = this.mapper.getSerializationConfig().getDefaultVisibilityChecker();
        visibilityChecker.withFieldVisibility(JsonAutoDetect.Visibility.ANY);
        visibilityChecker.withGetterVisibility(JsonAutoDetect.Visibility.ANY);
        visibilityChecker.withSetterVisibility(JsonAutoDetect.Visibility.ANY);
        visibilityChecker.withCreatorVisibility(JsonAutoDetect.Visibility.ANY);
        this.mapper.setVisibilityChecker(visibilityChecker);
    }

    @Override
    public boolean canTransform(Object response, HttpRequest request, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        if (response != null && !(response instanceof File) && !(response instanceof InputStream)) {
            for (MediaType type : request.getMediaTypes()) {
                if (!type.isCompatible(MediaType.APPLICATION_JSON_TYPE)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void transform(Object response, HttpRequest request, HttpResponse httpResponse, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        this.transform(response, request, httpResponse, mediaType, method, ctx, null);
    }

    @Override
    public JsonTransformer instance() {
        return new JsonTransformer();
    }

    public void transform(Object response, HttpRequest request, HttpResponse res, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx, HttpResponseStatus status) {
        byte[] data = null;
        if (response == null) {
            data = "{}".getBytes();
        } else {
            try {
                data = this.mapper.writeValueAsBytes(response);
            }
            catch (JsonProcessingException e) {
                this.log.warn("Unable to transform response to JSON", (Throwable)e);
                res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (data != null) {
            res.setStatus(status == null ? HttpStatus.OK : status);
            res.content().writeBytes(data);
            HttpHeaders.setContentLength((HttpMessage)res, (long)data.length);
        }
    }

    public int priority() {
        return 0;
    }
}

