/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers;

import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpResponse;
import io.higgs.http.server.WebApplicationException;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.protocol.HttpProtocolConfiguration;
import io.higgs.http.server.resource.MediaType;
import io.higgs.http.server.transformers.BaseTransformer;
import io.higgs.http.server.transformers.JsonTransformer;
import io.higgs.http.server.transformers.ResponseTransformer;
import io.higgs.http.server.transformers.ThymeleafTransformer;
import io.higgs.http.server.transformers.thymeleaf.WebContext;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.HashMap;
import java.util.Map;

public class HttpErrorTransformer
extends BaseTransformer {
    private final HttpProtocolConfiguration protocolConfiguration;
    private final JsonTransformer json;
    private final ThymeleafTransformer thymeleaf;
    protected Map<Integer, String> templates = new HashMap<Integer, String>();

    public HttpErrorTransformer(HttpProtocolConfiguration protocolConfiguration, JsonTransformer json, ThymeleafTransformer thymeleaf) {
        this.protocolConfiguration = protocolConfiguration;
        this.json = json;
        this.thymeleaf = thymeleaf;
    }

    @Override
    public boolean canTransform(Object response, HttpRequest request, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        return response instanceof Throwable;
    }

    @Override
    public void transform(Object response, HttpRequest request, HttpResponse httpResponse, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        if (response instanceof Throwable) {
            this.buildErrorResponse((Throwable)response, request, httpResponse, mediaType, method, ctx);
        }
    }

    private void buildErrorResponse(Throwable throwable, HttpRequest request, HttpResponse httpResponse, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        WebContext webContext = new WebContext();
        webContext.setVariable("status", 500);
        webContext.setVariable("name", "Internal Server Error");
        String templateName = this.templates.get(500);
        if (templateName == null) {
            templateName = this.protocolConfiguration.getServer().getConfig().default_error_template;
        }
        if (throwable instanceof WebApplicationException) {
            WebApplicationException e = (WebApplicationException)throwable;
            webContext.setVariable("status", e.getStatus().code());
            webContext.setVariable("name", e.getStatus().reasonPhrase());
            if (e.hasRequest()) {
                this.handleWAE(e, webContext, request, httpResponse, mediaType, method, ctx);
            } else {
                this.thymeleaf.instance().transform(webContext, templateName, throwable, request, httpResponse, mediaType, method, ctx, e.getStatus() != null ? e.getStatus() : null);
            }
        } else if (request != null) {
            this.handleAnyThrowableWithRequest(webContext, templateName, throwable, request, httpResponse, mediaType, method, ctx);
        } else {
            this.thymeleaf.instance().transform(webContext, templateName, throwable, request, httpResponse, mediaType, method, ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void handleAnyThrowableWithRequest(WebContext webContext, String templateName, Throwable throwable, HttpRequest request, HttpResponse httpResponse, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        boolean thymeleafMediaType = true;
        for (MediaType type : request.getMediaTypes()) {
            if (!type.isCompatible(MediaType.TEXT_PLAIN_TYPE) && !type.isCompatible(MediaType.APPLICATION_JSON_TYPE)) continue;
            thymeleafMediaType = false;
            break;
        }
        if (thymeleafMediaType) {
            this.thymeleaf.transform(webContext, templateName, throwable, request, httpResponse, mediaType, method, ctx, null);
        } else {
            this.json.transform(null, request, httpResponse, mediaType, method, ctx);
        }
    }

    protected void handleWAE(WebApplicationException e, WebContext webContext, HttpRequest request, HttpResponse httpResponse, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        HttpResponseStatus status = e.getStatus();
        String templateName = this.templates.get(status.code());
        if (templateName == null) {
            templateName = this.protocolConfiguration.getServer().getConfig().default_error_template;
        }
        boolean thymeleafMediaType = true;
        for (MediaType type : e.getRequest().getMediaTypes()) {
            if (type.isWildcardType() || !type.isCompatible(MediaType.TEXT_PLAIN_TYPE) && !type.isCompatible(MediaType.APPLICATION_JSON_TYPE)) continue;
            thymeleafMediaType = false;
            break;
        }
        if (thymeleafMediaType) {
            this.thymeleaf.transform(webContext, templateName, e, request, httpResponse, mediaType, method, ctx, status);
        } else {
            this.json.transform(null, request, httpResponse, mediaType, method, ctx, status);
        }
    }

    public void setErrorTemplate(HttpResponseStatus status, String template2) {
        this.setErrorTemplate(status.code(), template2);
    }

    public void setErrorTemplate(int status, String template2) {
        if (template2 != null) {
            this.templates.put(status, template2);
        }
    }

    @Override
    public ResponseTransformer instance() {
        return new HttpErrorTransformer(this.protocolConfiguration, this.json, this.thymeleaf);
    }

    public int priority() {
        return Integer.MIN_VALUE;
    }
}

