/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.protocol;

import io.higgs.core.MethodProcessor;
import io.higgs.core.ObjectFactory;
import io.higgs.http.server.MethodParam;
import io.higgs.http.server.params.CookieParam;
import io.higgs.http.server.params.DefaultValidator;
import io.higgs.http.server.params.FormParam;
import io.higgs.http.server.params.HeaderParam;
import io.higgs.http.server.params.IllegalValidatorException;
import io.higgs.http.server.params.PathParam;
import io.higgs.http.server.params.QueryParam;
import io.higgs.http.server.params.SessionParam;
import io.higgs.http.server.params.valid;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.protocol.HttpProtocolConfiguration;
import io.higgs.http.server.resource.template;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMethodProcessor
implements MethodProcessor {
    private final HttpProtocolConfiguration config;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public HttpMethodProcessor(HttpProtocolConfiguration config) {
        this.config = config;
    }

    public HttpMethod process(Method method2, Class<?> klass, Queue<ObjectFactory> factories) {
        HttpMethod im = new HttpMethod(factories, klass, method2);
        this.determineTemplate(method2, klass, im);
        Class<?>[] parameters = method2.getParameterTypes();
        Annotation[][] methodAnnotations = method2.getParameterAnnotations();
        for (int i = 0; i < methodAnnotations.length; ++i) {
            Annotation[] paramterAnnotations = methodAnnotations[i];
            if (i == 0) {
                im.initialiseParams(methodAnnotations.length);
            }
            Class<?> parameterType = parameters[i];
            MethodParam methodParam = new MethodParam();
            methodParam.setParameterType(parameterType);
            methodParam.setPosition(i);
            im.setParam(methodParam);
            for (Annotation annotation : paramterAnnotations) {
                if (annotation.annotationType().isAssignableFrom(valid.class)) {
                    valid validationParam = (valid)annotation;
                    methodParam.setValidationRequired(true);
                    if (DefaultValidator.class.isAssignableFrom(validationParam.value())) {
                        methodParam.setValidator(new DefaultValidator());
                        continue;
                    }
                    try {
                        methodParam.setValidator(validationParam.value().newInstance());
                        continue;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalValidatorException("All validators must have a publicly accessible no-args constructor", e);
                    }
                }
                if (annotation.annotationType().isAssignableFrom(SessionParam.class)) {
                    SessionParam sessionParam = (SessionParam)annotation;
                    if (sessionParam.value() == null || sessionParam.value().isEmpty()) continue;
                    methodParam.setSessionParam(true);
                    methodParam.setName(sessionParam.value());
                    continue;
                }
                if (annotation.annotationType().isAssignableFrom(PathParam.class)) {
                    PathParam pathParam = (PathParam)annotation;
                    methodParam.setPathParam(true);
                    if (pathParam.value() == null || pathParam.value().isEmpty()) continue;
                    methodParam.setName(pathParam.value());
                    continue;
                }
                if (annotation.annotationType().isAssignableFrom(QueryParam.class)) {
                    QueryParam queryParam = (QueryParam)annotation;
                    methodParam.setQueryParam(true);
                    if (queryParam.value() == null || queryParam.value().isEmpty()) continue;
                    methodParam.setName(queryParam.value());
                    continue;
                }
                if (annotation.annotationType().isAssignableFrom(FormParam.class)) {
                    FormParam formParam = (FormParam)annotation;
                    methodParam.setFormParam(true);
                    if (formParam.value() == null || formParam.value().isEmpty()) continue;
                    methodParam.setName(formParam.value());
                    continue;
                }
                if (annotation.annotationType().isAssignableFrom(CookieParam.class)) {
                    CookieParam cookieParam = (CookieParam)annotation;
                    methodParam.setCookieParam(true);
                    if (cookieParam.value() == null || cookieParam.value().isEmpty()) continue;
                    methodParam.setName(cookieParam.value());
                    continue;
                }
                if (annotation.annotationType().isAssignableFrom(HeaderParam.class)) {
                    HeaderParam headerParam = (HeaderParam)annotation;
                    methodParam.setHeaderParam(true);
                    if (headerParam.value() == null || headerParam.value().isEmpty()) continue;
                    methodParam.setName(headerParam.value());
                    continue;
                }
                this.log.warn(String.format("Unknown param type annotation %s", annotation.annotationType().getName()));
            }
        }
        return im;
    }

    private void determineTemplate(Method method2, Class<?> klass, HttpMethod im) {
        template template2;
        boolean classHasTemplate = klass.isAnnotationPresent(template.class);
        String methodTemplate = null;
        if (classHasTemplate) {
            template2 = klass.getAnnotation(template.class);
            if (template2.value() != null && !template2.value().isEmpty()) {
                methodTemplate = template2.value();
            }
            im.setTemplate(template2.fragments());
        }
        if (method2.isAnnotationPresent(template.class)) {
            template2 = method2.getAnnotation(template.class);
            if (template2.value() != null && !template2.value().isEmpty()) {
                methodTemplate = template2.value();
            }
            im.setTemplate(template2.fragments());
        }
        im.setTemplate(methodTemplate);
    }
}

