/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.protocol;

import io.higgs.core.InvokableMethod;
import io.higgs.core.ObjectFactory;
import io.higgs.core.ResourcePath;
import io.higgs.core.reflect.dependency.DependencyProvider;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.MethodParam;
import io.higgs.http.server.WebApplicationException;
import io.higgs.http.server.params.ValidationResult;
import io.higgs.http.server.resource.MediaType;
import io.higgs.http.server.resource.Produces;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Queue;

public class HttpMethod
extends InvokableMethod {
    private MethodParam[] params = new MethodParam[0];
    private LinkedList<MediaType> mediaTypes = new LinkedList();
    private String template;
    private ValidationResult validationResult;
    private String[] fragments = new String[0];

    public HttpMethod(Queue<ObjectFactory> factories, Class<?> klass, Method classMethod) {
        super(factories, klass, classMethod);
        this.parseMediaTypes();
    }

    public void parseMediaTypes() {
        String[] classProduces = new String[]{};
        String[] methodProduces = new String[]{};
        if (this.klass.isAnnotationPresent(Produces.class)) {
            String[] stringArray;
            Produces produces = this.klass.getAnnotation(Produces.class);
            if (produces.value() != null) {
                stringArray = produces.value();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*/*";
            }
            classProduces = stringArray;
        }
        if (this.classMethod.isAnnotationPresent(Produces.class)) {
            String[] stringArray;
            Produces path = this.classMethod.getAnnotation(Produces.class);
            if (path.value() != null) {
                stringArray = path.value();
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "*/*";
            }
            methodProduces = stringArray;
        }
        String[] mTypes = new String[classProduces.length + methodProduces.length];
        System.arraycopy(classProduces, 0, mTypes, 0, classProduces.length);
        System.arraycopy(methodProduces, 0, mTypes, classProduces.length, methodProduces.length);
        for (String mType : mTypes) {
            LinkedList<MediaType> mediaTypeList = MediaType.valueOf(mType);
            this.mediaTypes.addAll(mediaTypeList);
        }
    }

    public boolean matches(String requestPath, ChannelHandlerContext ctx, Object msg) {
        ResourcePath resourcePath = this.path();
        if (resourcePath.matches(requestPath)) {
            if (!(msg instanceof HttpRequest)) {
                return true;
            }
            HttpRequest request = (HttpRequest)((Object)msg);
            request.setPath(resourcePath);
            if (this.mediaTypes.size() > 0) {
                for (MediaType producesMediaType : this.mediaTypes) {
                    for (MediaType acceptedMediaType : request.getMediaTypes()) {
                        if (!producesMediaType.isCompatible(acceptedMediaType)) continue;
                        request.setMatchedMediaType(producesMediaType);
                        return true;
                    }
                }
                this.log.debug(String.format("template %s matched %s but no compatible media types found", requestPath, resourcePath.getUri()));
                throw new WebApplicationException(HttpResponseStatus.NOT_ACCEPTABLE, request);
            }
            return true;
        }
        return false;
    }

    protected Object[] injectParameters(ChannelHandlerContext ctx, Object msg, Object[] params, Object instance, DependencyProvider deps) {
        return params;
    }

    public void setParam(MethodParam param) {
        this.params[param.getPosition()] = param;
    }

    public MethodParam[] getParams() {
        return this.params;
    }

    public void initialiseParams(int length) {
        this.params = new MethodParam[length];
    }

    public boolean hasTemplate() {
        return this.template != null || this.fragments.length > 0;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template2) {
        this.template = template2;
    }

    public void setTemplate(String[] fragments) {
        this.fragments = fragments;
    }

    public String[] getFragments() {
        return this.fragments;
    }

    public boolean hasFragments() {
        return this.fragments.length > 0;
    }

    public void setValidationResult(ValidationResult validationResult) {
        this.validationResult = validationResult;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }
}

