/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.protocol;

import io.higgs.core.FixedSortedList;
import io.higgs.core.InvokableMethod;
import io.higgs.core.MessageHandler;
import io.higgs.core.reflect.dependency.DependencyProvider;
import io.higgs.core.reflect.dependency.Injector;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpResponse;
import io.higgs.http.server.HttpStatus;
import io.higgs.http.server.MessagePusher;
import io.higgs.http.server.ParamInjector;
import io.higgs.http.server.StaticFileMethod;
import io.higgs.http.server.WebApplicationException;
import io.higgs.http.server.WrappedResponse;
import io.higgs.http.server.config.HttpConfig;
import io.higgs.http.server.params.HttpFile;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.protocol.HttpProtocolConfiguration;
import io.higgs.http.server.transformers.ResponseTransformer;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHandler
extends MessageHandler<HttpConfig, Object> {
    protected static final Class<HttpMethod> methodClass = HttpMethod.class;
    protected static HttpDataFactory factory = new DefaultHttpDataFactory(16384L);
    protected HttpRequest request;
    protected HttpResponse res;
    protected HttpMethod method;
    protected ParamInjector injector;
    protected HttpProtocolConfiguration protocolConfig;
    protected HttpPostRequestDecoder decoder;
    private Logger requestLogger = LoggerFactory.getLogger((String)"request_logger");
    private boolean replied;

    public HttpHandler(HttpProtocolConfiguration config) {
        super(config.getServer().getConfig());
        HttpConfig c = (HttpConfig)config.getServer().getConfig();
        this.protocolConfig = config;
        this.injector = config.getInjector();
        DiskFileUpload.deleteOnExitTemporaryFile = c.files.delete_temp_on_exit;
        DiskFileUpload.baseDirectory = c.files.temp_directory;
        DiskAttribute.deleteOnExitTemporaryFile = c.files.delete_temp_on_exit;
        DiskAttribute.baseDirectory = c.files.temp_directory;
    }

    public <M extends InvokableMethod> M findMethod(String path, ChannelHandlerContext ctx, Object msg, Class<M> methodClass) {
        StaticFileMethod fileMethod;
        InvokableMethod m = super.findMethod(path, ctx, msg, methodClass);
        if (m == null && ((HttpConfig)this.config).add_static_resource_filter && (fileMethod = new StaticFileMethod(this.protocolConfig.getServer().getFactories(), this.protocolConfig)).matches(path, ctx, msg)) {
            return (M)((Object)fileMethod);
        }
        return (M)m;
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof LastHttpContent && !(msg instanceof FullHttpRequest) && this.replied) {
            return;
        }
        this.replied = false;
        if (msg instanceof HttpRequest || msg instanceof FullHttpRequest) {
            this.request = msg instanceof HttpRequest ? (HttpRequest)((Object)msg) : new HttpRequest((FullHttpRequest)msg);
            this.res = new HttpResponse(ctx.alloc().buffer());
            this.protocolConfig.getTranscriber().transcribe(this.request);
            this.request.setConfig(this.protocolConfig);
            this.request.init(ctx);
            this.method = this.findMethod(this.request.getUri(), ctx, (Object)this.request, methodClass);
            if (this.method == null) {
                throw new WebApplicationException(HttpStatus.NOT_FOUND, this.request);
            }
            this.request.setPath(this.method.path());
        }
        if (this.request == null || this.method == null) {
            this.log.warn(String.format("Method or request is null \n method \n%s \n request \n%s", new Object[]{this.method, this.request}));
            throw new WebApplicationException(HttpStatus.INTERNAL_SERVER_ERROR, this.request);
        }
        if (!io.netty.handler.codec.http.HttpMethod.POST.name().equalsIgnoreCase(this.request.getMethod().name()) && !io.netty.handler.codec.http.HttpMethod.PUT.name().equalsIgnoreCase(this.request.getMethod().name())) {
            if (msg instanceof LastHttpContent) {
                this.invoke(ctx);
            }
        } else {
            if (this.decoder == null) {
                try {
                    this.decoder = new HttpPostRequestDecoder(factory, (io.netty.handler.codec.http.HttpRequest)this.request);
                }
                catch (HttpPostRequestDecoder.ErrorDataDecoderException e1) {
                    this.log.warn("Unable to decode data", (Throwable)e1);
                    throw new WebApplicationException(HttpStatus.BAD_REQUEST, this.request);
                }
                catch (HttpPostRequestDecoder.IncompatibleDataDecoderException e) {
                    this.log.warn("Incompatible request type", (Throwable)e);
                    throw new WebApplicationException(HttpStatus.BAD_REQUEST, this.request);
                }
            }
            this.request.setChunked(HttpHeaders.isTransferEncodingChunked((HttpMessage)this.request));
            this.request.setMultipart(this.decoder.isMultipart());
            if (msg instanceof HttpContent) {
                HttpContent chunk = (HttpContent)msg;
                try {
                    this.decoder.offer(chunk);
                }
                catch (HttpPostRequestDecoder.ErrorDataDecoderException e1) {
                    this.log.warn("Unable to decode HTTP chunk", (Throwable)e1);
                    throw new WebApplicationException(HttpStatus.BAD_REQUEST, this.request);
                }
                this.readHttpDataChunkByChunk();
                if (chunk instanceof LastHttpContent) {
                    this.allHttpDataReceived(ctx);
                }
            }
        }
    }

    private void readHttpDataChunkByChunk() {
        try {
            while (this.decoder.hasNext()) {
                InterfaceHttpData data = this.decoder.next();
                if (data == null) continue;
                this.writeHttpData(data);
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException endOfDataDecoderException) {
            // empty catch block
        }
    }

    private void writeHttpData(InterfaceHttpData data) {
        block9: {
            if (data.getHttpDataType() == InterfaceHttpData.HttpDataType.Attribute) {
                Attribute field = (Attribute)data;
                try {
                    String name = field.getName();
                    int idx = name.indexOf("[");
                    if (idx != -1 && name.endsWith("]")) {
                        String realName = name.substring(0, idx);
                        String fieldName = name.substring(idx + 1).replace(']', ' ').trim();
                        if (this.request.getFormParam().get(realName) == null) {
                            this.request.getFormParam().put(realName, new HashMap());
                        }
                        ((HashMap)this.request.getFormParam().get(realName)).put(fieldName, field.getValue());
                        break block9;
                    }
                    this.request.addFormField(name, field.getValue());
                }
                catch (IOException e) {
                    this.log.warn(String.format("unable to extract form field's value, field name = %s", field.getName()));
                }
            } else if (data instanceof FileUpload) {
                this.request.addFormFile(new HttpFile((FileUpload)data));
            } else if (data != null) {
                this.log.warn(String.format("Unknown form type encountered Class: %s,data type:%s,name:%s", data.getClass().getName(), data.getHttpDataType().name(), data.getName()));
            }
        }
    }

    private void allHttpDataReceived(ChannelHandlerContext ctx) {
        List data;
        try {
            data = this.decoder.getBodyHttpDatas();
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException e1) {
            this.log.warn("Not enough data to decode", (Throwable)e1);
            throw new WebApplicationException(HttpStatus.BAD_REQUEST, this.request);
        }
        for (InterfaceHttpData httpData : data) {
            this.writeHttpData(httpData);
        }
        this.invoke(ctx);
    }

    protected void invoke(final ChannelHandlerContext ctx) {
        MessagePusher pusher = new MessagePusher(){

            @Override
            public ChannelFuture push(Object message) {
                Object wrappedRes;
                Object object = wrappedRes = message != null && message instanceof WrappedResponse ? ((WrappedResponse)message).data() : null;
                if (wrappedRes != null) {
                    message = wrappedRes;
                }
                Queue<ResponseTransformer> transformers = HttpHandler.this.protocolConfig.getTransformers();
                return HttpHandler.this.writeResponse(ctx, message, transformers);
            }

            @Override
            public ChannelHandlerContext ctx() {
                return ctx;
            }
        };
        Object[] params = Injector.inject((Class[])this.method.method().getParameterTypes(), (Object[])new Object[0], (DependencyProvider)DependencyProvider.from((Object[])new Object[]{pusher}));
        this.injector.injectParams(this.method, this.request, this.res, ctx, params);
        try {
            Object response = this.method.invoke(ctx, this.request.getUri(), (Object)this.method, params);
            pusher.push(response);
        }
        catch (Throwable t) {
            if (t.getCause() instanceof WebApplicationException) {
                throw (WebApplicationException)t.getCause();
            }
            this.logDetailedFailMessage(true, params, t, this.method.method());
            throw new WebApplicationException(HttpStatus.INTERNAL_SERVER_ERROR, this.request, t);
        }
    }

    protected ChannelFuture writeResponse(ChannelHandlerContext ctx, Object response, Queue<ResponseTransformer> t) {
        if (this.res.isRedirect()) {
            return this.doWrite(ctx);
        }
        if (response instanceof HttpResponse) {
            this.res = (HttpResponse)((Object)response);
            return this.doWrite(ctx);
        }
        FixedSortedList ts = new FixedSortedList(t);
        boolean notAcceptable = false;
        for (ResponseTransformer transformer : ts) {
            if (transformer.canTransform(response, this.request, this.request.getMatchedMediaType(), this.method, ctx)) {
                transformer.transform(response, this.request, this.res, this.request.getMatchedMediaType(), this.method, ctx);
                notAcceptable = false;
                break;
            }
            notAcceptable = true;
        }
        if (notAcceptable) {
            this.res.setStatus(HttpStatus.NOT_ACCEPTABLE);
        }
        return this.doWrite(ctx);
    }

    protected ChannelFuture doWrite(ChannelHandlerContext ctx) {
        boolean close;
        this.res.finalizeCustomHeaders(this.request);
        if (((HttpConfig)this.config).log_requests) {
            SocketAddress address = ctx.channel().remoteAddress();
            this.requestLogger.info(String.format("%s - [%s] \"%s %s %s\" %s %s", address, HttpHeaders.getDate((HttpMessage)this.request, (Date)this.request.getCreatedAt().toDate()), this.request.getMethod().name(), this.request.getUri(), this.request.getProtocolVersion(), this.res.getStatus().code(), HttpHeaders.getHeader((HttpMessage)this.res, (String)"Content-Length") == null ? (long)this.res.content().writerIndex() : HttpHeaders.getContentLength((HttpMessage)this.res)));
        }
        boolean bl = close = "close".equalsIgnoreCase(this.request.headers().get("Connection")) || this.request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0) && !"keep-alive".equalsIgnoreCase(this.request.headers().get("Connection"));
        if (!close && this.res.getManagedWriter() == null) {
            HttpHeaders.setContentLength((HttpMessage)this.res, (long)this.res.content().readableBytes());
        }
        ChannelFuture future = this.res.getManagedWriter() == null ? ctx.writeAndFlush((Object)this.res) : this.res.doManagedWrite();
        if (close) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        this.request = null;
        this.res = null;
        this.decoder = null;
        this.replied = true;
        return future;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try {
            if (cause instanceof WebApplicationException) {
                this.writeResponse(ctx, cause, this.protocolConfig.getErrorTransformers());
            } else {
                this.log.warn(String.format("Error while processing request %s", new Object[]{this.request}), cause);
                this.writeResponse(ctx, new WebApplicationException(HttpStatus.INTERNAL_SERVER_ERROR, this.request, cause), this.protocolConfig.getErrorTransformers());
            }
        }
        catch (Throwable t) {
            this.log.warn(String.format("Uncaught error while processing request %s", new Object[]{this.request}), cause);
            this.res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            this.doWrite(ctx);
        }
    }
}

