/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server;

import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpStatus;
import io.netty.handler.codec.http.HttpResponseStatus;

public class WebApplicationException
extends RuntimeException {
    private HttpResponseStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
    private String template;
    private Object response;
    private HttpRequest request;

    public WebApplicationException(HttpResponseStatus status) {
        this.status = status;
    }

    public WebApplicationException(HttpResponseStatus status, HttpRequest request) {
        this(status);
        this.request = request;
    }

    public WebApplicationException(HttpResponseStatus status, String template2, HttpRequest request) {
        this(status, request);
        this.template = template2;
    }

    public WebApplicationException(HttpResponseStatus status, Object response, HttpRequest request, String template2) {
        this(status, template2, request);
        this.response = response;
    }

    public WebApplicationException(HttpResponseStatus status, Object response, HttpRequest request) {
        this(status, response, request, null);
    }

    public WebApplicationException(WebApplicationException cause) {
        this(cause.getStatus(), cause.getResponse(), cause.getRequest(), cause.getTemplate());
    }

    public WebApplicationException(HttpResponseStatus status, String template2) {
        this(status, template2, null);
    }

    public WebApplicationException(HttpResponseStatus status, HttpRequest request, Throwable cause) {
        super(cause);
        this.status = status;
        this.request = request;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public void setRequest(HttpRequest request) {
        this.request = request;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public String getTemplate() {
        return this.template;
    }

    public Object getResponse() {
        return this.response;
    }

    public void setStatus(HttpResponseStatus status) {
        this.status = status;
    }

    public void setTemplate(String template2) {
        this.template = template2;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    @Override
    public String toString() {
        return "WebApplicationException{status=" + this.status + ", template='" + this.template + '\'' + ", response=" + this.response + ", path=" + (this.request == null ? "null" : this.request.getUri()) + '}';
    }
}

