/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server;

import io.higgs.core.Sortable;
import java.util.regex.Pattern;

public class Transcription
implements Sortable<Transcription> {
    private Pattern pattern;
    private final long createdAt = System.nanoTime();
    private boolean replaceWholeRequest;
    private String replacementPath;
    private boolean replaceFirstOccurrence;
    private int priority;

    public Transcription(Pattern regex, String replaceWith, boolean replaceEntirePath, boolean firstOccurrenceOnly) {
        if (regex == null) {
            throw new NullPointerException("A regex is required");
        }
        if (replaceWith == null) {
            throw new NullPointerException("A replacement string is required");
        }
        this.pattern = regex;
        this.setReplacementPath(replaceWith);
        this.setReplaceWholeRequest(replaceEntirePath);
        this.setReplaceFirstOccurrence(firstOccurrenceOnly);
    }

    public Transcription(String regex, String replaceWith, boolean replaceEntirePath) {
        this(Pattern.compile(regex), replaceWith, replaceEntirePath, false);
    }

    public Transcription(String regex, String replaceWith) {
        this(Pattern.compile(regex), replaceWith, true, false);
    }

    public Transcription(Pattern pattern, String replaceWith) {
        this(pattern, replaceWith, true, false);
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        if (pattern == null) {
            throw new NullPointerException("You must provide a transcription pattern");
        }
        this.pattern = pattern;
    }

    public boolean matches(String uri) {
        return this.pattern.matcher(uri).matches();
    }

    public boolean isReplaceWholeRequest() {
        return this.replaceWholeRequest;
    }

    public void setReplaceWholeRequest(boolean replace) {
        this.replaceWholeRequest = replace;
    }

    public String getReplacementPath() {
        return this.replacementPath;
    }

    public void setReplacementPath(String replaceWith) {
        this.replacementPath = replaceWith;
    }

    public String replaceAllMatches(String uri) {
        return this.pattern.matcher(uri).replaceAll(this.getReplacementPath());
    }

    public String replaceFirstMatch(String uri) {
        return this.pattern.matcher(uri).replaceFirst(this.getReplacementPath());
    }

    public boolean isReplaceFirstOccurrence() {
        return this.replaceFirstOccurrence;
    }

    public void setReplaceFirstOccurrence(boolean firstOccurrenceOnly) {
        this.replaceFirstOccurrence = firstOccurrenceOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Transcription)) {
            return false;
        }
        Transcription that = (Transcription)o;
        if (this.createdAt != that.createdAt) {
            return false;
        }
        if (this.replaceFirstOccurrence != that.replaceFirstOccurrence) {
            return false;
        }
        if (this.replaceWholeRequest != that.replaceWholeRequest) {
            return false;
        }
        if (this.pattern != null ? !this.pattern.equals(that.pattern) : that.pattern != null) {
            return false;
        }
        return !(this.replacementPath == null ? that.replacementPath != null : !this.replacementPath.equals(that.replacementPath));
    }

    public int hashCode() {
        int result = this.pattern != null ? this.pattern.hashCode() : 0;
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (this.replaceWholeRequest ? 1 : 0);
        result = 31 * result + (this.replacementPath != null ? this.replacementPath.hashCode() : 0);
        result = 31 * result + (this.replaceFirstOccurrence ? 1 : 0);
        return result;
    }

    public int priority() {
        return this.priority;
    }

    public int compareTo(Transcription that) {
        return that.priority() - this.priority();
    }
}

