/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server;

import io.higgs.core.ObjectFactory;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.config.HttpConfig;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.protocol.HttpProtocolConfiguration;
import io.higgs.http.server.transformers.JarFile;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Queue;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileMethod
extends HttpMethod {
    private static final Pattern INSECURE_URI = Pattern.compile(".*[<>&\"].*");
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;
    private final HttpProtocolConfiguration config;
    private File base;
    private boolean canServe = true;
    private static Logger log = LoggerFactory.getLogger(StaticFileMethod.class);
    private static final Method METHOD;
    private JarFile jarFile;
    private File matchedFile;

    public StaticFileMethod(Queue<ObjectFactory> factories, HttpProtocolConfiguration protocolConfig) {
        super(factories, StaticFileMethod.class, METHOD);
        this.config = protocolConfig;
        this.base = StaticFileMethod.baseUri(((HttpConfig)this.config.getServer().getConfig()).files.public_directory);
        if (this.base != null && !this.base.exists()) {
            this.canServe = false;
            log.warn("Public files directory that is configured does not exist. Will not serve static files");
        }
    }

    public static File baseUri(String public_directory) {
        URL uri = Thread.currentThread().getContextClassLoader().getResource(public_directory);
        File file = null;
        if (uri != null) {
            try {
                file = new File(uri.toURI());
            }
            catch (URISyntaxException e) {
                log.info("", (Throwable)e);
            }
        }
        if (file == null && !(file = new File(public_directory)).exists()) {
            log.warn("Public files directory that is configured does not exist. Will not serve static files");
        }
        return file;
    }

    @Override
    public boolean matches(String requestPath, ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof HttpRequest)) {
            return false;
        }
        HttpRequest request = (HttpRequest)((Object)msg);
        if (!this.canServe || !request.getMethod().name().equalsIgnoreCase(io.netty.handler.codec.http.HttpMethod.GET.name())) {
            return false;
        }
        String base_dir = ((HttpConfig)this.config.getServer().getConfig()).files.public_directory;
        String uri = this.normalizeURI(request, base_dir);
        uri = base_dir + this.sanitizeUri(uri);
        File file = null;
        URL source = Thread.currentThread().getContextClassLoader().getResource(uri);
        try {
            if (source != null) {
                String url = source.toExternalForm();
                if (url.startsWith("jar:")) {
                    boolean fromJar = this.returnJarStreamEndpoint(url);
                    if (fromJar) {
                        return fromJar;
                    }
                } else {
                    file = new File(source.toURI());
                    if (file.isHidden() || !file.exists()) {
                        file = null;
                    }
                }
            }
        }
        catch (Throwable e) {
            log.debug("", e);
        }
        if (!(file != null || (file = new File(uri)).isDirectory() || !file.isHidden() && file.exists())) {
            return false;
        }
        if (!this.isSubDirectory(this.base, file)) {
            return false;
        }
        if (file.isDirectory()) {
            try {
                DirectoryStream<Path> paths = Files.newDirectoryStream(file.toPath());
                boolean list = true;
                for (Path localPath : paths) {
                    Path name = localPath.getFileName();
                    if (!((HttpConfig)this.config.getServer().getConfig()).files.index_file.endsWith(name.toString())) continue;
                    file = localPath.toFile();
                    list = false;
                    break;
                }
                if (list) {
                    if (((HttpConfig)this.config.getServer().getConfig()).files.enable_directory_listing) {
                        this.matchedFile = file;
                        return true;
                    }
                    return false;
                }
            }
            catch (IOException e) {
                log.info(String.format("Failed to list files in directory {%s}", e.getMessage()));
                return false;
            }
        }
        if (!file.isFile()) {
            return false;
        }
        this.matchedFile = file;
        return true;
    }

    private String normalizeURI(HttpRequest request, String base_dir) {
        String uri = request.getUri();
        if (uri.contains("?")) {
            uri = uri.substring(0, uri.indexOf("?"));
        }
        if (uri.equals("/") && ((HttpConfig)this.config.getServer().getConfig()).files.serve_index_file) {
            uri = ((HttpConfig)this.config.getServer().getConfig()).files.index_file;
        }
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        if (base_dir.endsWith("/")) {
            uri = uri.substring(1);
        }
        return uri;
    }

    public Object getFile() {
        if (this.jarFile != null) {
            return this.jarFile;
        }
        return this.matchedFile;
    }

    public Object invoke(ChannelHandlerContext ctx, String path, Object msg, Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        return this.classMethod.invoke((Object)this, params);
    }

    private boolean returnJarStreamEndpoint(String url) throws IOException {
        String jar = url.substring(url.indexOf(":") + 1, url.indexOf("!"));
        String jarFile = url.substring(url.indexOf("!") + 1);
        ZipFile zip = new ZipFile(jar);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        if (entries != null) {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!jarFile.equalsIgnoreCase(entry.getName())) continue;
                this.jarFile = new JarFile(zip, entry, zip.getInputStream(entry));
                return true;
            }
        }
        return false;
    }

    public boolean isSubDirectory(File base, File child) {
        try {
            base = base.getCanonicalFile();
            for (File parentFile = child = child.getCanonicalFile(); parentFile != null; parentFile = parentFile.getParentFile()) {
                if (!base.equals(parentFile)) continue;
                return true;
            }
        }
        catch (IOException e) {
            log.debug("", (Throwable)e);
        }
        return false;
    }

    private String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error();
            }
        }
        if (!uri.startsWith("/")) {
            return null;
        }
        if ((uri = uri.replace('/', File.separatorChar)).contains(File.separator + '.') || uri.contains('.' + File.separator) || uri.startsWith(".") || uri.endsWith(".") || INSECURE_URI.matcher(uri).matches()) {
            return null;
        }
        return uri;
    }

    public int priority() {
        return Integer.MIN_VALUE;
    }

    static {
        try {
            METHOD = StaticFileMethod.class.getMethod("getFile", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to set up static file method", e);
        }
    }
}

