/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server;

import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpStatus;
import io.higgs.http.server.ManagedWriter;
import io.higgs.http.server.params.HttpCookie;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.ServerCookieEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HttpResponse
extends DefaultFullHttpResponse {
    private Map<String, HttpCookie> newCookies = new HashMap<String, HttpCookie>();
    private ManagedWriter managedWriter;
    private ByteBuf content = Unpooled.buffer();
    private HttpResponseStatus status = HttpResponseStatus.OK;
    private HttpVersion version = HttpVersion.HTTP_1_1;
    private HttpHeaders headers = new DefaultHttpHeaders();
    private DecoderResult result;
    private boolean redirect;

    public HttpResponse(HttpVersion version, HttpResponseStatus status, ByteBuf content) {
        super(version, status);
        this.version = version;
        this.status = status;
        this.content = content;
    }

    public HttpResponse(HttpVersion version, HttpResponseStatus status) {
        this(version, status, Unpooled.buffer());
    }

    public HttpResponse(HttpResponseStatus status) {
        this(HttpVersion.HTTP_1_1, status);
    }

    public HttpResponse(HttpRequest message) {
        this(message == null ? HttpVersion.HTTP_1_1 : message.getProtocolVersion(), HttpStatus.OK);
        if (message != null) {
            String conn = message.headers().get("Connection");
            if (conn == null) {
                conn = "close";
            }
            this.headers().set("Connection", (Object)conn);
        }
    }

    public HttpResponse() {
        this(HttpResponseStatus.OK);
    }

    public HttpResponse(ByteBuf buffer) {
        this(HttpVersion.HTTP_1_1, HttpStatus.OK, buffer);
    }

    public HttpResponse(HttpStatus status, ByteBuf buffer) {
        this(HttpVersion.HTTP_1_1, status, buffer);
    }

    public ByteBuf content() {
        return this.content;
    }

    public void setCookies(Map<String, HttpCookie> cookies) {
        this.newCookies.putAll(cookies);
    }

    public void setCookie(String name, String value) {
        HttpCookie cookie = new HttpCookie(name, value);
        cookie.setPath("/");
        this.newCookies.put(name, cookie);
    }

    public void setCookie(HttpCookie cookie) {
        this.newCookies.put(cookie.getName(), cookie);
    }

    public void clearHeaders() {
        this.newCookies.clear();
        this.headers().clear();
    }

    public void finalizeCustomHeaders(HttpRequest request) {
        if (this.newCookies.size() > 0 || request.isNewSession()) {
            HashMap<String, HttpCookie> cookies = new HashMap<String, HttpCookie>();
            if (request.isNewSession() || request.getCookie("HS3-ID") == null) {
                cookies.put(request.getSessionCookie().getName(), request.getSessionCookie());
            }
            cookies.putAll(this.newCookies);
            this.headers().set("Set-Cookie", (Iterable)ServerCookieEncoder.encode(new ArrayList(cookies.values())));
        }
    }

    public ChannelFuture doManagedWrite() {
        if (this.managedWriter != null && !this.managedWriter.isDone()) {
            return this.managedWriter.doWrite();
        }
        return null;
    }

    public void setManagedWriter(ManagedWriter managedWriter) {
        this.managedWriter = managedWriter;
    }

    public ManagedWriter getManagedWriter() {
        return this.managedWriter;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public FullHttpResponse setStatus(HttpResponseStatus status) {
        this.status = status;
        return this;
    }

    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    public FullHttpResponse setProtocolVersion(HttpVersion version) {
        this.version = version;
        return this;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public DecoderResult getDecoderResult() {
        return this.result;
    }

    public void setDecoderResult(DecoderResult result) {
        this.result = result;
    }

    public void redirect(String to) {
        this.setStatus(HttpResponseStatus.SEE_OTHER);
        this.headers().set("Location", (Object)to);
        this.redirect = true;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void resetContent(ByteBuf buffer) {
        this.content = buffer;
    }
}

