/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server;

import io.higgs.core.ResourcePath;
import io.higgs.core.reflect.ReflectionUtil;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpResponse;
import io.higgs.http.server.MethodParam;
import io.higgs.http.server.ParamInjector;
import io.higgs.http.server.params.FormFiles;
import io.higgs.http.server.params.FormParams;
import io.higgs.http.server.params.HttpCookie;
import io.higgs.http.server.params.HttpCookies;
import io.higgs.http.server.params.HttpSession;
import io.higgs.http.server.params.QueryParams;
import io.higgs.http.server.params.RequiredParam;
import io.higgs.http.server.params.ValidationResult;
import io.higgs.http.server.protocol.HttpMethod;
import io.netty.channel.ChannelHandlerContext;
import java.nio.channels.Channel;
import java.util.List;

public class DefaultParamInjector
implements ParamInjector {
    @Override
    public Object[] injectParams(HttpMethod method2, HttpRequest request, HttpResponse res, ChannelHandlerContext ctx, Object[] args) {
        MethodParam[] params = method2.getParams();
        ResourcePath path = method2.path();
        ResourcePath.Component[] components = new ResourcePath.Component[]{};
        if (path != null) {
            components = path.getComponents();
        }
        ValidationResult result = new ValidationResult();
        method2.setValidationResult(result);
        for (int i = 0; i < params.length; ++i) {
            if (args[i] != null) continue;
            MethodParam param = params[i];
            if (ValidationResult.class.isAssignableFrom(param.getParameterType())) {
                args[i] = result;
                continue;
            }
            Object o = param.isNamed() ? this.processAnnotations(method2, request, param, params, path, components, ctx) : this.processClasses(method2, request, res, param, params, path, components, ctx);
            if (param.isValidationRequired()) {
                boolean valid2 = param.getValidator().isValid(o);
                args[i] = RequiredParam.class.isAssignableFrom(param.getParameterType()) ? new RequiredParam<Object>(o, valid2) : o;
                result.put(param.getName() + "_valid", valid2);
                if (valid2) continue;
                result.invalid();
                result.put(param.getName(), param.getValidator().getValidationMessage(param));
                continue;
            }
            result.put(param.getName() + "_valid", true);
            args[i] = o;
        }
        return args;
    }

    private Object processClasses(HttpMethod method2, HttpRequest request, HttpResponse res, MethodParam param, MethodParam[] params, ResourcePath path, ResourcePath.Component[] components, ChannelHandlerContext ctx) {
        if (io.netty.handler.codec.http.HttpRequest.class.isAssignableFrom(param.getParameterType())) {
            return request;
        }
        if (FormFiles.class.isAssignableFrom(param.getParameterType())) {
            return request.getFormFiles();
        }
        if (HttpResponse.class.isAssignableFrom(param.getParameterType())) {
            return res;
        }
        if (FormParams.class.isAssignableFrom(param.getParameterType())) {
            return request.getFormParam();
        }
        if (HttpCookies.class.isAssignableFrom(param.getParameterType())) {
            return request.getCookies();
        }
        if (QueryParams.class.isAssignableFrom(param.getParameterType())) {
            return request.getQueryParams();
        }
        if (HttpSession.class.isAssignableFrom(param.getParameterType())) {
            return request.getSession();
        }
        if (ResourcePath.class.isAssignableFrom(param.getParameterType())) {
            return path;
        }
        if (ChannelHandlerContext.class.isAssignableFrom(param.getParameterType())) {
            return ctx;
        }
        if (Channel.class.isAssignableFrom(param.getParameterType())) {
            return ctx.channel();
        }
        return null;
    }

    private Object processAnnotations(HttpMethod method2, HttpRequest request, MethodParam param, MethodParam[] params, ResourcePath path, ResourcePath.Component[] components, ChannelHandlerContext ctx) {
        if (param.isCookieParam()) {
            return this.extractCookieParam(param, request);
        }
        if (param.isHeaderParam()) {
            return this.extractHeaderParam(param, request);
        }
        if (param.isFormParam()) {
            return this.extractFormParam(param, request);
        }
        if (param.isQueryParam()) {
            return this.extractQueryParam(param, request);
        }
        if (param.isPathParam()) {
            return this.extractPathParam(param, path);
        }
        if (param.isSessionParam()) {
            return request.getSession() == null ? null : request.getSession().get(param.getName());
        }
        return null;
    }

    protected Object extractPathParam(MethodParam param, ResourcePath path) {
        ResourcePath.Component component = path.getComponent(param.getName());
        if (String.class.isAssignableFrom(param.getParameterType())) {
            if (component != null) {
                return component.getRuntimeValue();
            }
        } else if (ReflectionUtil.isNumeric(param.getParameterType())) {
            return this.extractNumberParam(param, component == null ? null : component.getRuntimeValue());
        }
        return null;
    }

    protected Object extractQueryParam(MethodParam param, HttpRequest request) {
        if (List.class.isAssignableFrom(param.getParameterType())) {
            return request.getQueryParams().get(param.getName());
        }
        if (String.class.isAssignableFrom(param.getParameterType())) {
            return request.getQueryParams().getFirst(param.getName());
        }
        if (ReflectionUtil.isNumeric(param.getParameterType())) {
            return this.extractNumberParam(param, request.getQueryParams().getFirst(param.getName()));
        }
        return null;
    }

    protected Object extractFormParam(MethodParam param, HttpRequest request) {
        Object obj = request.getFormParam().get(param.getName());
        if (obj != null && param.getParameterType().isAssignableFrom(obj.getClass())) {
            return obj;
        }
        if (ReflectionUtil.isNumeric(param.getParameterType())) {
            return this.extractNumberParam(param, (String)request.getFormParam().get(param.getName()));
        }
        return null;
    }

    protected Object extractHeaderParam(MethodParam param, HttpRequest request) {
        if (List.class.isAssignableFrom(param.getParameterType())) {
            return request.headers().getAll(param.getName());
        }
        if (String.class.isAssignableFrom(param.getParameterType())) {
            return request.headers().get(param.getName());
        }
        if (ReflectionUtil.isNumeric(param.getParameterType())) {
            return this.extractNumberParam(param, request.headers().get(param.getName()));
        }
        return null;
    }

    protected Object extractCookieParam(MethodParam param, HttpRequest request) {
        HttpCookie cookie = request.getCookie(param.getName());
        if (cookie == null) {
            return null;
        }
        if (String.class.isAssignableFrom(param.getParameterType())) {
            return cookie.getValue();
        }
        if (HttpCookie.class.isAssignableFrom(param.getParameterType())) {
            return cookie;
        }
        if (ReflectionUtil.isNumeric(param.getParameterType())) {
            return this.extractNumberParam(param, cookie.getValue());
        }
        return null;
    }

    protected Object extractNumberParam(MethodParam param, String value) {
        try {
            if (Integer.class.isAssignableFrom(param.getParameterType())) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            if (Long.class.isAssignableFrom(param.getParameterType())) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            if (Float.class.isAssignableFrom(param.getParameterType())) {
                try {
                    return Float.valueOf(Float.parseFloat(value));
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            if (Double.class.isAssignableFrom(param.getParameterType())) {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            if (Short.class.isAssignableFrom(param.getParameterType())) {
                try {
                    return Short.parseShort(value);
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            if (Byte.class.isAssignableFrom(param.getParameterType())) {
                try {
                    return Byte.parseByte(value);
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            if (Integer.TYPE.isAssignableFrom(param.getParameterType())) {
                return Integer.parseInt(value);
            }
            if (Long.TYPE.isAssignableFrom(param.getParameterType())) {
                return Long.parseLong(value);
            }
            if (Float.TYPE.isAssignableFrom(param.getParameterType())) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (Double.TYPE.isAssignableFrom(param.getParameterType())) {
                return Double.parseDouble(value);
            }
            if (Short.TYPE.isAssignableFrom(param.getParameterType())) {
                return Short.parseShort(value);
            }
            if (Byte.TYPE.isAssignableFrom(param.getParameterType())) {
                return Byte.parseByte(value);
            }
            return 0;
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }
}

