/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.resource;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MediaType {
    public static final String MEDIA_TYPE_WILDCARD = "*";
    public static final String WILDCARD = "*/*";
    public static final MediaType WILDCARD_TYPE = new MediaType();
    public static final String APPLICATION_XML = "application/xml";
    public static final MediaType APPLICATION_XML_TYPE = new MediaType("application", "xml");
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final MediaType APPLICATION_ATOM_XML_TYPE = new MediaType("application", "atom+xml");
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final MediaType APPLICATION_XHTML_XML_TYPE = new MediaType("application", "xhtml+xml");
    public static final String APPLICATION_SVG_XML = "application/svg+xml";
    public static final MediaType APPLICATION_SVG_XML_TYPE = new MediaType("application", "svg+xml");
    public static final String APPLICATION_JSON = "application/json";
    public static final MediaType APPLICATION_JSON_TYPE = new MediaType("application", "json");
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final MediaType APPLICATION_FORM_URLENCODED_TYPE = new MediaType("application", "x-www-form-urlencoded");
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final MediaType MULTIPART_FORM_DATA_TYPE = new MediaType("multipart", "form-data");
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final MediaType APPLICATION_OCTET_STREAM_TYPE = new MediaType("application", "octet-stream");
    public static final String TEXT_PLAIN = "text/plain";
    public static final MediaType TEXT_PLAIN_TYPE = new MediaType("text", "plain");
    public static final String TEXT_XML = "text/xml";
    public static final MediaType TEXT_XML_TYPE = new MediaType("text", "xml");
    public static final String TEXT_HTML = "text/html";
    public static final MediaType TEXT_HTML_TYPE = new MediaType("text", "html");
    private static final Map<String, String> emptyMap = Collections.emptyMap();
    private String type;
    private String subtype;
    private Map<String, String> parameters;

    public MediaType() {
        this(MEDIA_TYPE_WILDCARD, MEDIA_TYPE_WILDCARD);
    }

    public MediaType(String type, String subtype) {
        this(type, subtype, emptyMap);
    }

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type == null ? MEDIA_TYPE_WILDCARD : type;
        String string = this.subtype = subtype == null ? MEDIA_TYPE_WILDCARD : subtype;
        if (parameters == null) {
            this.parameters = emptyMap == null ? Collections.unmodifiableMap(new HashMap()) : emptyMap;
        } else {
            TreeMap<String, String> map = new TreeMap<String, String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                map.put(e.getKey().toLowerCase(), e.getValue());
            }
            this.parameters = Collections.unmodifiableMap(map);
        }
    }

    public static LinkedList<MediaType> valueOf(String mtype) {
        LinkedList<MediaType> types = new LinkedList<MediaType>();
        if (mtype == null) {
            return types;
        }
        Set<String> individualTypes = MediaType.parseDelimitedType(mtype.length(), mtype, ",");
        for (String m : individualTypes) {
            String[] parts;
            int idx = m.indexOf(";");
            MediaType type = new MediaType();
            String typeSubType = m;
            if (idx != -1) {
                typeSubType = m.substring(0, idx);
                String strParams = m.substring(idx + 1);
                Set<String> params = MediaType.parseDelimitedType(strParams.length(), strParams, ";");
                if (params.size() > 0) {
                    type.parameters = new HashMap<String, String>();
                }
                for (String p : params) {
                    int eqIdx = p.indexOf("=");
                    if (eqIdx == -1) continue;
                    String name = p.substring(0, eqIdx);
                    String value = p.substring(eqIdx + 1);
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    type.parameters.put(name.trim(), value.trim());
                }
            }
            if ((parts = typeSubType.split("/")).length <= 1) continue;
            type.type = parts[0];
            type.subtype = parts[1];
            types.add(type);
        }
        return types;
    }

    private static Set<String> parseDelimitedType(int length, String str, String separator) {
        HashSet<String> tmp = new HashSet<String>();
        int start = 0;
        int end = 0;
        String tmpChunk = "";
        String chunk = "";
        while (end < length) {
            end = str.indexOf(separator);
            if (end == -1) {
                if (!str.isEmpty()) {
                    if (tmpChunk.isEmpty()) {
                        tmp.add(str);
                    } else {
                        tmp.add(tmpChunk + str);
                    }
                }
                end = length;
                continue;
            }
            chunk = str.substring(start, end);
            str = str.substring(end);
            if (chunk.lastIndexOf(34) != -1 || MediaType.countOccurrences(tmpChunk, '\"') == 1) {
                str = str.substring(1);
                tmpChunk = tmpChunk + chunk + separator;
                continue;
            }
            if (tmpChunk.endsWith(separator)) {
                tmpChunk = tmpChunk.substring(0, tmpChunk.length() - 1);
            }
            if (chunk.endsWith(separator)) {
                chunk = chunk.substring(0, chunk.length() - 1);
            }
            if (!tmpChunk.isEmpty()) {
                tmp.add(tmpChunk);
            }
            if (!chunk.isEmpty()) {
                tmp.add(chunk);
            }
            chunk = "";
            tmpChunk = "";
            str = str.substring(1);
        }
        return tmp;
    }

    public static int countOccurrences(String haystack, char needle) {
        int count = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }

    public boolean isWildcardType() {
        return this.getType().equals(MEDIA_TYPE_WILDCARD);
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardSubtype() {
        return this.getSubtype().equals(MEDIA_TYPE_WILDCARD);
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isCompatible(MediaType other) {
        if (other == null) {
            return false;
        }
        if (other.type == null || other.subtype == null) {
            return false;
        }
        if (this.type.equals(MEDIA_TYPE_WILDCARD) || other.type.equals(MEDIA_TYPE_WILDCARD)) {
            return true;
        }
        if (this.type.equalsIgnoreCase(other.type) && (this.subtype.equals(MEDIA_TYPE_WILDCARD) || other.subtype.equals(MEDIA_TYPE_WILDCARD))) {
            return true;
        }
        return this.type.trim().equalsIgnoreCase(other.type.trim()) && this.subtype.trim().equalsIgnoreCase(other.subtype.trim());
    }

    public int hashCode() {
        return (this.type.toLowerCase() + this.subtype.toLowerCase()).hashCode() + this.parameters.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype) && this.parameters.equals(other.parameters);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.type).append("/").append(this.subtype);
        if (this.parameters.size() > 0) {
            b.append(";");
        }
        int added = 0;
        for (String name : this.parameters.keySet()) {
            String attribute = this.parameters.get(name);
            b.append(' ').append(name).append('=').append('\"').append(attribute).append('\"');
            if (this.parameters.size() <= 1 || ++added >= this.parameters.size()) continue;
            b.append(';');
        }
        return b.toString();
    }
}

