/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.protocol.mediaTypeDecoders;

import io.higgs.core.reflect.dependency.DependencyProvider;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpStatus;
import io.higgs.http.server.params.HttpFile;
import io.higgs.http.server.protocol.MediaTypeDecoder;
import io.higgs.http.server.resource.MediaType;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormUrlEncodedDecoder
implements MediaTypeDecoder {
    protected static HttpDataFactory factory = new DefaultHttpDataFactory(16384L);
    protected final HttpRequest request;
    protected HttpPostRequestDecoder decoder;
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public FormUrlEncodedDecoder(HttpRequest request) {
        this.request = request;
        try {
            this.decoder = new HttpPostRequestDecoder(factory, (io.netty.handler.codec.http.HttpRequest)request);
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e1) {
            this.log.warn("Unable to decode data", (Throwable)e1);
            throw new WebApplicationException(HttpStatus.BAD_REQUEST.code());
        }
        catch (HttpPostRequestDecoder.IncompatibleDataDecoderException e) {
            this.log.warn("Incompatible request type", (Throwable)e);
            throw new WebApplicationException(HttpStatus.BAD_REQUEST.code());
        }
        request.setMultipart(this.decoder.isMultipart());
    }

    @Override
    public boolean canDecode(List<MediaType> mediaType) {
        if (mediaType == null || mediaType.size() == 0) {
            return true;
        }
        for (MediaType m : mediaType) {
            if (!MediaType.APPLICATION_FORM_URLENCODED_TYPE.isCompatible(m) && !MediaType.MULTIPART_FORM_DATA_TYPE.isCompatible(m)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void offer(HttpContent chunk) {
        try {
            this.decoder.offer(chunk);
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e1) {
            this.log.warn("Unable to decode HTTP chunk", (Throwable)e1);
            throw new WebApplicationException(HttpStatus.BAD_REQUEST.code());
        }
        try {
            while (this.decoder.hasNext()) {
                InterfaceHttpData data = this.decoder.next();
                if (data == null) continue;
                this.writeHttpData(data);
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException endOfDataDecoderException) {
            // empty catch block
        }
    }

    private void writeHttpData(InterfaceHttpData data) {
        block8: {
            if (data.getHttpDataType() == InterfaceHttpData.HttpDataType.Attribute) {
                Attribute field = (Attribute)data;
                try {
                    String name = field.getName();
                    int idx = name.indexOf("[");
                    if (idx != -1 && name.endsWith("]")) {
                        String realName = name.substring(0, idx);
                        String fieldName = name.substring(idx + 1).replace(']', ' ').trim();
                        if (this.request.getFormParam().get(realName) == null) {
                            this.request.getFormParam().put(realName, new HashMap());
                        }
                        ((HashMap)this.request.getFormParam().get(realName)).put(fieldName, field.getValue());
                        break block8;
                    }
                    this.request.addFormField(name, field.getValue());
                }
                catch (IOException e) {
                    this.log.warn(String.format("unable to extract form field's value, field name = %s", field.getName()));
                }
            } else if (data instanceof FileUpload) {
                this.request.addFormFile(new HttpFile((FileUpload)data));
            } else {
                this.log.warn(String.format("Unknown form type encountered Class: %s,data type:%s,name:%s", data.getClass().getName(), data.getHttpDataType().name(), data.getName()));
            }
        }
    }

    @Override
    public void finished(ChannelHandlerContext ctx) {
        List data;
        try {
            data = this.decoder.getBodyHttpDatas();
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException e1) {
            this.log.warn("Not enough data to decode", (Throwable)e1);
            throw new WebApplicationException(HttpStatus.BAD_REQUEST.code());
        }
        for (InterfaceHttpData httpData : data) {
            this.writeHttpData(httpData);
        }
    }

    @Override
    public DependencyProvider provider() {
        return DependencyProvider.from((Object[])new Object[0]);
    }
}

