/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.protocol;

import io.higgs.core.InvokableMethod;
import io.higgs.core.ObjectFactory;
import io.higgs.core.ResourcePath;
import io.higgs.core.reflect.dependency.DependencyProvider;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.MethodParam;
import io.higgs.http.server.params.ValidationResult;
import io.higgs.http.server.resource.MediaType;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;

public class HttpMethod
extends InvokableMethod {
    private MethodParam[] params = new MethodParam[0];
    private LinkedList<MediaType> producesMediaTypes = new LinkedList();
    private LinkedList<MediaType> consumesMediaTypes = new LinkedList();
    private String template;
    private ValidationResult validationResult;
    private String[] fragments = new String[0];
    private List<VERB> verbs = new ArrayList<VERB>();

    public HttpMethod(Queue<ObjectFactory> factories, Class<?> klass, Method classMethod) {
        super(factories, klass, classMethod);
        this.parseMediaTypes();
    }

    public void parseMediaTypes() {
        String[] classProduces = new String[]{};
        String[] methodProduces = new String[]{};
        if (this.klass.isAnnotationPresent(Produces.class)) {
            String[] stringArray;
            Produces produces = this.klass.getAnnotation(Produces.class);
            if (produces.value() != null) {
                stringArray = produces.value();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*/*";
            }
            classProduces = stringArray;
        }
        if (this.classMethod.isAnnotationPresent(Produces.class)) {
            String[] stringArray;
            Produces path = this.classMethod.getAnnotation(Produces.class);
            if (path.value() != null) {
                stringArray = path.value();
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "*/*";
            }
            methodProduces = stringArray;
        }
        String[] mTypes = new String[classProduces.length + methodProduces.length];
        System.arraycopy(classProduces, 0, mTypes, 0, classProduces.length);
        System.arraycopy(methodProduces, 0, mTypes, classProduces.length, methodProduces.length);
        for (String mType : mTypes) {
            LinkedList<MediaType> mediaTypeList = MediaType.valueOf(mType);
            this.producesMediaTypes.addAll(mediaTypeList);
        }
        String[] classConsumes = new String[]{};
        String[] methodConsumes = new String[]{};
        if (this.klass.isAnnotationPresent(Consumes.class)) {
            String[] stringArray;
            Consumes consumes = this.klass.getAnnotation(Consumes.class);
            if (consumes.value() != null) {
                stringArray = consumes.value();
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = "*/*";
            }
            classConsumes = stringArray;
        }
        if (this.classMethod.isAnnotationPresent(Consumes.class)) {
            String[] stringArray;
            Consumes path = this.classMethod.getAnnotation(Consumes.class);
            if (path.value() != null) {
                stringArray = path.value();
            } else {
                String[] stringArray5 = new String[1];
                stringArray = stringArray5;
                stringArray5[0] = "*/*";
            }
            methodConsumes = stringArray;
        }
        String[] consumesTypes = new String[classConsumes.length + methodConsumes.length];
        System.arraycopy(classConsumes, 0, consumesTypes, 0, classConsumes.length);
        System.arraycopy(methodConsumes, 0, consumesTypes, classConsumes.length, methodConsumes.length);
        for (String mType : consumesTypes) {
            LinkedList<MediaType> mediaTypeList = MediaType.valueOf(mType);
            this.consumesMediaTypes.addAll(mediaTypeList);
        }
    }

    public LinkedList<MediaType> getConsumesMediaTypes() {
        return this.consumesMediaTypes;
    }

    public boolean produces(MediaType ... mediaTypes) {
        for (MediaType mt : this.producesMediaTypes) {
            for (MediaType mt2 : mediaTypes) {
                if (!mt.isCompatible(mt2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasProduces() {
        return this.getProducesMediaTypes().size() > 0;
    }

    public LinkedList<MediaType> getProducesMediaTypes() {
        return this.producesMediaTypes;
    }

    protected Object[] injectParameters(ChannelHandlerContext ctx, Object msg, Object[] params, Object instance, DependencyProvider deps) {
        return params;
    }

    public boolean matches(String requestPath, ChannelHandlerContext ctx, Object msg) {
        ResourcePath resourcePath = this.path();
        if (resourcePath.matches(requestPath)) {
            if (!(msg instanceof HttpRequest)) {
                return true;
            }
            HttpRequest request = (HttpRequest)((Object)msg);
            request.setPath(resourcePath);
            if (!this.matchesVerb(request.getMethod().name())) {
                return false;
            }
            if (this.consumesMediaTypes.size() > 0) {
                String strType;
                String string = strType = request.headers() == null ? null : request.headers().get("Content-Type");
                if (strType != null && !strType.isEmpty()) {
                    LinkedList<MediaType> contentType = MediaType.valueOf(strType);
                    boolean consumesType = false;
                    block0: for (MediaType consumesMediaType : this.consumesMediaTypes) {
                        for (MediaType type : contentType) {
                            if (!consumesMediaType.isCompatible(type)) continue;
                            consumesType = true;
                            continue block0;
                        }
                    }
                    if (!consumesType) {
                        return false;
                    }
                }
            }
            if (this.producesMediaTypes.size() > 0) {
                for (MediaType producesMediaType : this.producesMediaTypes) {
                    for (MediaType acceptedMediaType : request.getAcceptedMediaTypes()) {
                        if (!producesMediaType.isCompatible(acceptedMediaType)) continue;
                        request.setMatchedMediaType(producesMediaType);
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean matchesVerb(String verb) {
        if (this.verbs.isEmpty()) {
            return true;
        }
        for (VERB v : this.verbs) {
            if (!v.matches(verb)) continue;
            return true;
        }
        return false;
    }

    public void setParam(MethodParam param) {
        this.params[param.getPosition()] = param;
    }

    public MethodParam[] getParams() {
        return this.params;
    }

    public void initialiseParams(int length) {
        this.params = new MethodParam[length];
    }

    public boolean hasTemplate() {
        return this.template != null || this.fragments.length > 0;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template2) {
        this.template = template2;
    }

    public void setTemplate(String[] fragments) {
        this.fragments = fragments;
    }

    public String[] getFragments() {
        return this.fragments;
    }

    public boolean hasFragments() {
        return this.fragments.length > 0;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public void setValidationResult(ValidationResult validationResult) {
        this.validationResult = validationResult;
    }

    public void addVerb(VERB a) {
        if (a != null) {
            this.verbs.add(a);
        }
    }

    public static enum VERB {
        GET("GET"),
        POST("POST"),
        PUT("PUT"),
        DELETE("DELETE"),
        HEAD("HEAD"),
        OPTIONS("OPTIONS");

        public final String value;

        private VERB(String a) {
            this.value = a;
        }

        public boolean matches(String method) {
            return this.value.equalsIgnoreCase(method);
        }
    }
}

