/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.protocol;

import io.higgs.core.FixedSortedList;
import io.higgs.core.InvokableMethod;
import io.higgs.core.MessageHandler;
import io.higgs.core.ResolvedFile;
import io.higgs.core.reflect.dependency.DependencyProvider;
import io.higgs.core.reflect.dependency.Injector;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpResponse;
import io.higgs.http.server.HttpStatus;
import io.higgs.http.server.MessagePusher;
import io.higgs.http.server.ParamInjector;
import io.higgs.http.server.StaticFileMethod;
import io.higgs.http.server.WrappedResponse;
import io.higgs.http.server.config.HttpConfig;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.protocol.HttpProtocolConfiguration;
import io.higgs.http.server.protocol.MediaTypeDecoder;
import io.higgs.http.server.protocol.mediaTypeDecoders.FormUrlEncodedDecoder;
import io.higgs.http.server.protocol.mediaTypeDecoders.JsonDecoder;
import io.higgs.http.server.transformers.ResponseTransformer;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.ws.rs.WebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHandler
extends MessageHandler<HttpConfig, Object> {
    protected static final Class<HttpMethod> methodClass = HttpMethod.class;
    protected final Queue<MediaTypeDecoder> mediaTypeDecoders = new ConcurrentLinkedDeque<MediaTypeDecoder>();
    protected final HttpConfig httpConfig;
    protected HttpRequest request;
    protected HttpResponse res;
    protected HttpMethod method;
    protected ParamInjector injector;
    protected HttpProtocolConfiguration protocolConfig;
    protected boolean replied;
    protected MediaTypeDecoder decoder;
    private Logger requestLogger = LoggerFactory.getLogger((String)"request_logger");

    public HttpHandler(HttpProtocolConfiguration config) {
        super(config.getServer().getConfig());
        this.httpConfig = (HttpConfig)config.getServer().getConfig();
        this.protocolConfig = config;
        this.injector = config.getInjector();
        this.mediaTypeDecoders.addAll(config.getMediaTypeDecoders());
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof LastHttpContent && !(msg instanceof FullHttpRequest) && this.replied) {
            return;
        }
        this.replied = false;
        if (msg instanceof HttpRequest || msg instanceof FullHttpRequest) {
            this.request = msg instanceof HttpRequest ? (HttpRequest)((Object)msg) : new HttpRequest((FullHttpRequest)msg);
            this.res = new HttpResponse(Unpooled.buffer());
            this.protocolConfig.getTranscriber().transcribe(this.request);
            this.request.setConfig(this.protocolConfig);
            this.request.init(ctx);
            this.method = this.findMethod(this.request.getUri(), ctx, (Object)this.request, methodClass);
            if (this.method == null) {
                throw new WebApplicationException(HttpStatus.NOT_FOUND.code());
            }
            if (this.isEntityRequest()) {
                if (this.httpConfig.add_form_url_decoder) {
                    this.mediaTypeDecoders.add(new FormUrlEncodedDecoder(this.request));
                }
                if (this.httpConfig.add_json_decoder) {
                    this.mediaTypeDecoders.add(new JsonDecoder(this.request));
                }
            }
        }
        if (this.request == null || this.method == null) {
            this.log.warn(String.format("Method or request is null \n method \n%s \n request \n%s", new Object[]{this.method, this.request}));
            throw new WebApplicationException(HttpStatus.INTERNAL_SERVER_ERROR.code());
        }
        if (!this.isEntityRequest()) {
            if (msg instanceof LastHttpContent) {
                this.invoke(ctx);
            }
        } else {
            if (this.decoder == null) {
                for (MediaTypeDecoder d : this.mediaTypeDecoders) {
                    if (!d.canDecode(this.request.getContentType())) continue;
                    this.decoder = d;
                    break;
                }
                if (this.decoder == null) {
                    throw new WebApplicationException(HttpResponseStatus.NOT_ACCEPTABLE.code());
                }
            }
            this.request.setChunked(HttpHeaders.isTransferEncodingChunked((HttpMessage)this.request));
            if (msg instanceof HttpContent) {
                HttpContent chunk = (HttpContent)msg;
                this.decoder.offer(chunk);
                if (chunk instanceof LastHttpContent) {
                    this.decoder.finished(ctx);
                    this.invoke(ctx);
                }
            }
        }
    }

    public <M extends InvokableMethod> M findMethod(String path, ChannelHandlerContext ctx, Object msg, Class<M> methodClass) {
        StaticFileMethod fileMethod;
        InvokableMethod m = super.findMethod(path, ctx, msg, methodClass);
        if (m == null && ((HttpConfig)this.config).add_static_resource_filter && (fileMethod = new StaticFileMethod(this.protocolConfig.getServer().getFactories(), this.protocolConfig)).matches(path, ctx, msg)) {
            return (M)((Object)fileMethod);
        }
        return (M)m;
    }

    private boolean isEntityRequest() {
        return io.netty.handler.codec.http.HttpMethod.POST.name().equalsIgnoreCase(this.request.getMethod().name()) || io.netty.handler.codec.http.HttpMethod.PUT.name().equalsIgnoreCase(this.request.getMethod().name());
    }

    protected void invoke(final ChannelHandlerContext ctx) {
        MessagePusher pusher = new MessagePusher(){

            @Override
            public ChannelFuture push(Object message) {
                Object wrappedRes;
                Object object = wrappedRes = message != null && message instanceof WrappedResponse ? ((WrappedResponse)message).data() : null;
                if (wrappedRes != null) {
                    message = wrappedRes;
                }
                Queue<ResponseTransformer> transformers = HttpHandler.this.protocolConfig.getTransformers();
                return HttpHandler.this.writeResponse(ctx, message, transformers);
            }

            @Override
            public ChannelHandlerContext ctx() {
                return ctx;
            }
        };
        DependencyProvider provider = this.decoder == null ? DependencyProvider.from((Object[])new Object[0]) : this.decoder.provider();
        provider.take(DependencyProvider.global());
        provider.add(new Object[]{ctx, ctx.channel(), ctx.executor(), this.request, this.res, this.request.getFormFiles(), this.request.getFormParam(), this.request.getCookies(), this.request.getSubject(), this.request.getSubject().getSession(), this.protocolConfig.getSecurityManager(), this.request.getQueryParams(), pusher, this.request.getPath()});
        Object[] params = Injector.inject((Class[])this.method.method().getParameterTypes(), (Object[])new Object[0], (DependencyProvider)provider);
        this.injector.injectParams(this.method, this.request, this.res, ctx, params);
        try {
            Object response = this.method.invoke(ctx, this.request.getUri(), (Object)this.method, params, provider);
            pusher.push(response);
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Throwable t) {
            if (t.getCause() instanceof WebApplicationException) {
                throw (WebApplicationException)t.getCause();
            }
            this.logDetailedFailMessage(true, params, t, this.method.method());
            throw new WebApplicationException(HttpStatus.INTERNAL_SERVER_ERROR.code());
        }
    }

    protected ChannelFuture writeResponse(ChannelHandlerContext ctx, Object response, Queue<ResponseTransformer> t) {
        if (this.res.isRedirect()) {
            return this.doWrite(ctx);
        }
        if (response instanceof HttpResponse) {
            this.res = (HttpResponse)((Object)response);
            return this.doWrite(ctx);
        }
        FixedSortedList ts = new FixedSortedList(t);
        boolean notAcceptable = false;
        for (ResponseTransformer transformer : ts) {
            if (transformer.canTransform(response, this.request, this.request.getMatchedMediaType(), this.method, ctx)) {
                transformer.transform(response, this.request, this.res, this.request.getMatchedMediaType(), this.method, ctx);
                notAcceptable = false;
                break;
            }
            notAcceptable = true;
        }
        if (notAcceptable) {
            this.res.setStatus(HttpStatus.NOT_ACCEPTABLE);
        }
        return this.doWrite(ctx);
    }

    protected ChannelFuture doWrite(ChannelHandlerContext ctx) {
        ChannelFuture future;
        boolean close;
        long responseSize = HttpHeaders.getHeader((HttpMessage)this.res, (String)"Content-Length") == null ? (long)this.res.content().writerIndex() : HttpHeaders.getContentLength((HttpMessage)this.res);
        this.res.finalizeCustomHeaders(this.request);
        boolean bl = close = "close".equalsIgnoreCase(this.request.headers().get("Connection")) || this.request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0) && !"keep-alive".equalsIgnoreCase(this.request.headers().get("Connection"));
        if (!close && this.res.getManagedWriter() == null) {
            HttpHeaders.setContentLength((HttpMessage)this.res, (long)this.res.content().readableBytes());
        }
        if (this.res.getManagedWriter() == null) {
            future = ctx.writeAndFlush((Object)this.res);
        } else {
            future = this.res.doManagedWrite();
            ResolvedFile f = this.res.getManagedWriter().getFile();
            if (f != null) {
                responseSize = f.size();
            }
        }
        if (close || !((HttpConfig)this.config).enable_keep_alive_requests) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        if (((HttpConfig)this.config).log_requests) {
            SocketAddress address = ctx.channel().remoteAddress();
            this.requestLogger.info(String.format("%s - [%s] \"%s %s %s\" %s %s", address, HttpHeaders.getDate((HttpMessage)this.request, (Date)this.request.getCreatedAt().toDate()), this.request.getMethod().name(), this.request.getUri(), this.request.getProtocolVersion(), this.res.getStatus().code(), responseSize));
        }
        this.request = null;
        this.res = null;
        this.decoder = null;
        this.replied = true;
        return future;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try {
            if (cause instanceof WebApplicationException) {
                this.writeResponse(ctx, cause, this.protocolConfig.getTransformers());
            } else {
                this.log.warn(String.format("Error while processing request %s", new Object[]{this.request}), cause);
                this.writeResponse(ctx, (Object)new WebApplicationException(HttpStatus.INTERNAL_SERVER_ERROR.code()), this.protocolConfig.getTransformers());
            }
        }
        catch (Throwable t) {
            this.log.warn(String.format("Uncaught error while processing request %s", new Object[]{this.request}), cause);
            this.res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
            this.doWrite(ctx);
        }
    }
}

