/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.auth;

import io.higgs.http.server.auth.FlashValue;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.StoppedSessionException;
import org.apache.shiro.session.mgt.ValidatingSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiggsSession
implements ValidatingSession,
Serializable {
    protected static final transient Logger log = LoggerFactory.getLogger(HiggsSession.class);
    protected static final long MILLIS_PER_SECOND = 1000L;
    protected static final long MILLIS_PER_MINUTE = 60000L;
    protected final Date startTimestamp;
    protected Serializable id;
    protected Date stopTimestamp;
    protected Date lastAccessTime;
    protected long timeout = 1800000L;
    protected boolean expired;
    protected String host;
    protected Map<Object, Object> attributes = new HashMap<Object, Object>();

    public HiggsSession(Serializable id) {
        this();
        this.setId(id);
    }

    public HiggsSession() {
        this.lastAccessTime = this.startTimestamp = new Date();
    }

    public void flash(Object key, Object value) {
        this.setAttribute(key, value instanceof FlashValue ? value : new FlashValue(value));
    }

    public void setAttributes(Map<Object, Object> attributes) {
        this.attributes = attributes;
    }

    public boolean isValid() {
        return !this.isStopped() && !this.isExpired();
    }

    protected boolean isStopped() {
        return this.getStopTimestamp() != null;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public Date getStopTimestamp() {
        return this.stopTimestamp;
    }

    public void setStopTimestamp(Date stopTimestamp) {
        this.stopTimestamp = stopTimestamp;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public void validate() throws InvalidSessionException {
        if (this.isStopped()) {
            String msg = "Session with id [" + this.getId() + "] has been " + "explicitly stopped.  No further interaction under this session is " + "allowed.";
            throw new StoppedSessionException(msg);
        }
        if (this.isTimedOut()) {
            this.expire();
            Date lastAccessTime = this.getLastAccessTime();
            long timeout = this.getTimeout();
            Serializable sessionId = this.getId();
            DateFormat df = DateFormat.getInstance();
            String msg = "Session with id [" + sessionId + "] has expired. " + "Last access time: " + df.format(lastAccessTime) + ".  Current time: " + df.format(new Date()) + ".  Session timeout is set to " + timeout / 1000L + " seconds (" + timeout / 60000L + " minutes)";
            if (log.isTraceEnabled()) {
                log.trace(msg);
            }
            throw new ExpiredSessionException(msg);
        }
    }

    public Serializable getId() {
        return this.id;
    }

    public void setId(Serializable id) {
        this.id = id;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void touch() {
        this.lastAccessTime = new Date();
    }

    public void stop() {
        if (this.stopTimestamp == null) {
            this.stopTimestamp = new Date();
        }
    }

    public Collection<Object> getAttributeKeys() throws InvalidSessionException {
        return this.attributes.keySet();
    }

    public Object getAttribute(Object key) {
        Object value = this.attributes.get(key);
        if (value instanceof FlashValue) {
            this.removeAttribute(key);
            return ((FlashValue)value).getValue();
        }
        return value;
    }

    public void setAttribute(Object key, Object value) {
        if (value == null) {
            this.removeAttribute(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    protected boolean isTimedOut() {
        if (this.isExpired()) {
            return true;
        }
        long timeout = this.getTimeout();
        if (timeout >= 0L) {
            Date lastAccessTime = this.getLastAccessTime();
            if (lastAccessTime == null) {
                String msg = "session.lastAccessTime for session with id [" + this.getId() + "] is null.  This value must be set at " + "least once, preferably at least upon instantiation.  Please check the " + this.getClass().getName() + " implementation and ensure " + "this value will be set (perhaps in the constructor?)";
                throw new IllegalStateException(msg);
            }
            long expireTimeMillis = System.currentTimeMillis() - timeout;
            Date expireTime = new Date(expireTimeMillis);
            return lastAccessTime.before(expireTime);
        }
        if (log.isTraceEnabled()) {
            log.trace("No timeout for session with id [" + this.getId() + "].  Session is not considered expired.");
        }
        return false;
    }

    protected void expire() {
        this.stop();
        this.expired = true;
    }

    public int hashCode() {
        Serializable id = this.getId();
        if (id != null) {
            return id.hashCode();
        }
        int hashCode = this.getStartTimestamp() != null ? this.getStartTimestamp().hashCode() : 0;
        hashCode = 31 * hashCode + (this.getStopTimestamp() != null ? this.getStopTimestamp().hashCode() : 0);
        hashCode = 31 * hashCode + (this.getLastAccessTime() != null ? this.getLastAccessTime().hashCode() : 0);
        hashCode = 31 * hashCode + Long.valueOf(Math.max(this.getTimeout(), 0L)).hashCode();
        hashCode = 31 * hashCode + Boolean.valueOf(this.isExpired()).hashCode();
        hashCode = 31 * hashCode + (this.getHost() != null ? this.getHost().hashCode() : 0);
        hashCode = 31 * hashCode + (this.attributes != null ? this.attributes.hashCode() : 0);
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HiggsSession) {
            HiggsSession other = (HiggsSession)obj;
            Serializable thisId = this.getId();
            Serializable otherId = other.getId();
            if (thisId != null && otherId != null) {
                return thisId.equals(otherId);
            }
            return this.onEquals(other);
        }
        return false;
    }

    protected boolean onEquals(HiggsSession ss) {
        return (this.getStartTimestamp() != null ? this.getStartTimestamp().equals(ss.getStartTimestamp()) : ss.getStartTimestamp() == null) && (this.getStopTimestamp() != null ? this.getStopTimestamp().equals(ss.getStopTimestamp()) : ss.getStopTimestamp() == null) && (this.getLastAccessTime() != null ? this.getLastAccessTime().equals(ss.getLastAccessTime()) : ss.getLastAccessTime() == null) && this.getTimeout() == ss.getTimeout() && this.isExpired() == ss.isExpired() && (this.getHost() != null ? this.getHost().equals(ss.getHost()) : ss.getHost() == null) && (this.attributes != null ? this.attributes.equals(ss.attributes) : ss.attributes == null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append(",id=").append(this.getId());
        return sb.toString();
    }
}

