/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.auth;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.MemorySessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;

public class DefaultHiggsSessionDAO
extends MemorySessionDAO
implements SessionDAO {
    protected Map<Serializable, Session> sessions = new HashMap<Serializable, Session>();

    public DefaultHiggsSessionDAO(String sessionDirName) {
    }

    public Serializable create(Session session) {
        this.createOrUpdateSession(session);
        return session.getId();
    }

    private boolean createOrUpdateSession(Session session) {
        this.sessions.put(session.getId(), session);
        return false;
    }

    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        Session session = this.sessions.get(sessionId);
        if (session == null || session.getId() == null || session.getId().toString().isEmpty()) {
            throw new UnknownSessionException();
        }
        return session;
    }

    public void update(Session session) throws UnknownSessionException {
        this.createOrUpdateSession(session);
    }

    public void delete(Session session) {
        this.sessions.remove(session.getId());
    }

    public Collection<Session> getActiveSessions() {
        return this.sessions.values();
    }
}

