/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server;

import io.higgs.core.FileUtil;
import io.higgs.core.ObjectFactory;
import io.higgs.core.ResolvedFile;
import io.higgs.core.reflect.dependency.DependencyProvider;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.config.HttpConfig;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.protocol.HttpProtocolConfiguration;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileMethod
extends HttpMethod {
    private static final Pattern INSECURE_URI = Pattern.compile(".*[<>&\"].*");
    private static final Method METHOD;
    private static Logger log;
    private final HttpProtocolConfiguration config;
    protected ResolvedFile resolvedFile;
    private Path base;

    public StaticFileMethod(Queue<ObjectFactory> factories, HttpProtocolConfiguration protocolConfig) {
        super(factories, StaticFileMethod.class, METHOD);
        this.config = protocolConfig;
        this.base = Paths.get(((HttpConfig)this.config.getServer().getConfig()).public_directory, new String[0]);
        this.setPriority(Integer.MIN_VALUE);
    }

    public ResolvedFile getFile() {
        return this.resolvedFile;
    }

    @Override
    public boolean matches(String requestPath, ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof HttpRequest)) {
            return false;
        }
        HttpRequest request = (HttpRequest)((Object)msg);
        if (!request.getMethod().name().equalsIgnoreCase(io.netty.handler.codec.http.HttpMethod.GET.name())) {
            return false;
        }
        String uri = this.normalizeURI(request);
        if ((uri = this.sanitizeUri(uri)) == null) {
            return false;
        }
        this.resolvedFile = FileUtil.resolve((Path)this.base, (Path)Paths.get(uri, new String[0]));
        if (this.resolvedFile.isDirectory()) {
            List paths = this.resolvedFile.getDirectoryIterator();
            boolean list = true;
            for (Path resolvedPath : paths) {
                if (!((HttpConfig)this.config.getServer().getConfig()).index_file.endsWith(this.resolvedFile.toString())) continue;
                this.resolvedFile = FileUtil.resolve((Path)resolvedPath);
                list = false;
                break;
            }
            if (list) {
                return ((HttpConfig)this.config.getServer().getConfig()).enable_directory_listing;
            }
        }
        if (!this.resolvedFile.exists()) {
            throw new WebApplicationException(this.resolvedFile.getName() + " not found", HttpResponseStatus.NOT_FOUND.code());
        }
        return this.resolvedFile.exists();
    }

    private String normalizeURI(HttpRequest request) {
        String uri = request.getUri();
        if (uri.contains("?")) {
            uri = uri.substring(0, uri.indexOf("?"));
        }
        if (uri.equals("/") && ((HttpConfig)this.config.getServer().getConfig()).serve_index_file) {
            uri = ((HttpConfig)this.config.getServer().getConfig()).index_file;
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        return uri;
    }

    private String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error();
            }
        }
        uri = uri.replace('/', File.separatorChar);
        if (uri.contains(File.separator + '.') || uri.contains('.' + File.separator) || uri.startsWith(".") || uri.endsWith(".") || INSECURE_URI.matcher(uri).matches()) {
            return null;
        }
        return uri;
    }

    public Object invoke(ChannelHandlerContext ctx, String path, Object msg, Object[] params, DependencyProvider provider) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        return this.classMethod.invoke((Object)this, params);
    }

    static {
        log = LoggerFactory.getLogger(StaticFileMethod.class);
        try {
            METHOD = StaticFileMethod.class.getMethod("getFile", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to set up static file method", e);
        }
    }
}

