/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.protocol;

import io.higgs.core.InvokableMethod;
import io.higgs.core.MethodProcessor;
import io.higgs.core.ObjectFactory;
import io.higgs.http.server.MethodParam;
import io.higgs.http.server.params.DefaultValidator;
import io.higgs.http.server.params.IllegalValidatorException;
import io.higgs.http.server.params.SessionParam;
import io.higgs.http.server.params.valid;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.protocol.HttpProtocolConfiguration;
import io.higgs.http.server.resource.template;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Queue;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMethodProcessor
implements MethodProcessor<HttpMethod> {
    private final HttpProtocolConfiguration config;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public HttpMethodProcessor(HttpProtocolConfiguration config) {
        this.config = config;
    }

    public HttpMethod process(Method method, Class<?> klass, Queue<ObjectFactory> factories) {
        InvokableMethod im = this.newMethod(method, (Class)klass, (Queue)factories);
        this.determineTemplate(method, klass, (HttpMethod)im);
        this.processVerbs((HttpMethod)im, method);
        Class<?>[] parameters = method.getParameterTypes();
        Annotation[][] methodAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < methodAnnotations.length; ++i) {
            Annotation[] paramterAnnotations = methodAnnotations[i];
            if (i == 0) {
                im.initialiseParams(methodAnnotations.length);
            }
            Class<?> parameterType = parameters[i];
            MethodParam methodParam = new MethodParam();
            methodParam.setParameterType(parameterType);
            methodParam.setPosition(i);
            im.setParam(methodParam);
            for (Annotation annotation : paramterAnnotations) {
                if (annotation.annotationType().isAssignableFrom(valid.class)) {
                    valid validationParam = (valid)annotation;
                    methodParam.setValidationRequired(true);
                    if (DefaultValidator.class.isAssignableFrom(validationParam.value())) {
                        methodParam.setValidator(new DefaultValidator());
                        continue;
                    }
                    try {
                        methodParam.setValidator(validationParam.value().newInstance());
                        continue;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalValidatorException("All validators must have a publicly accessible no-args constructor", e);
                    }
                }
                if (annotation.annotationType().isAssignableFrom(SessionParam.class)) {
                    SessionParam sessionParam = (SessionParam)annotation;
                    if (sessionParam.value() == null || sessionParam.value().isEmpty()) continue;
                    methodParam.setSessionParam(true);
                    methodParam.setName(sessionParam.value());
                    continue;
                }
                if (annotation.annotationType().isAssignableFrom(PathParam.class)) {
                    PathParam pathParam = (PathParam)annotation;
                    methodParam.setPathParam(true);
                    if (pathParam.value() == null || pathParam.value().isEmpty()) continue;
                    methodParam.setName(pathParam.value());
                    continue;
                }
                if (annotation.annotationType().isAssignableFrom(QueryParam.class)) {
                    QueryParam queryParam = (QueryParam)annotation;
                    methodParam.setQueryParam(true);
                    if (queryParam.value() == null || queryParam.value().isEmpty()) continue;
                    methodParam.setName(queryParam.value());
                    continue;
                }
                if (annotation.annotationType().isAssignableFrom(FormParam.class)) {
                    FormParam formParam = (FormParam)annotation;
                    methodParam.setFormParam(true);
                    if (formParam.value() == null || formParam.value().isEmpty()) continue;
                    methodParam.setName(formParam.value());
                    continue;
                }
                if (annotation.annotationType().isAssignableFrom(CookieParam.class)) {
                    CookieParam cookieParam = (CookieParam)annotation;
                    methodParam.setCookieParam(true);
                    if (cookieParam.value() == null || cookieParam.value().isEmpty()) continue;
                    methodParam.setName(cookieParam.value());
                    continue;
                }
                if (annotation.annotationType().isAssignableFrom(HeaderParam.class)) {
                    HeaderParam headerParam = (HeaderParam)annotation;
                    methodParam.setHeaderParam(true);
                    if (headerParam.value() == null || headerParam.value().isEmpty()) continue;
                    methodParam.setName(headerParam.value());
                    continue;
                }
                this.log.warn(String.format("Unknown param type annotation %s", annotation.annotationType().getName()));
            }
        }
        return im;
    }

    public HttpMethod newMethod(Method method, Class<?> klass, Queue<ObjectFactory> factories) {
        return new HttpMethod(factories, klass, method);
    }

    private void determineTemplate(Method method, Class<?> klass, HttpMethod im) {
        template template2;
        boolean classHasTemplate = klass.isAnnotationPresent(template.class);
        String methodTemplate = null;
        boolean templateAnnotationFound = classHasTemplate;
        if (classHasTemplate) {
            template2 = klass.getAnnotation(template.class);
            if (template2.value() != null && !template2.value().isEmpty()) {
                methodTemplate = template2.value();
            }
            im.setTemplate(template2.fragments());
        }
        if (method.isAnnotationPresent(template.class)) {
            templateAnnotationFound = true;
            template2 = method.getAnnotation(template.class);
            if (template2.value() != null && !template2.value().isEmpty()) {
                methodTemplate = template2.value();
            }
            im.setTemplate(template2.fragments());
        }
        im.setTemplate(methodTemplate);
        if (templateAnnotationFound && !im.hasFragments() && !im.hasTemplate()) {
            throw new IllegalStateException(String.format("%s in %s has template annotation but hasn't provided a template or any fragments", method.getName(), klass.getName()));
        }
    }

    private void processVerbs(HttpMethod im, Method method) {
        Annotation[] annotations;
        for (Annotation a : annotations = method.getAnnotations()) {
            if (GET.class.isAssignableFrom(a.annotationType())) {
                im.addVerb(HttpMethod.VERB.GET);
            }
            if (POST.class.isAssignableFrom(a.annotationType())) {
                im.addVerb(HttpMethod.VERB.POST);
            }
            if (PUT.class.isAssignableFrom(a.annotationType())) {
                im.addVerb(HttpMethod.VERB.PUT);
            }
            if (DELETE.class.isAssignableFrom(a.annotationType())) {
                im.addVerb(HttpMethod.VERB.DELETE);
            }
            if (HEAD.class.isAssignableFrom(a.annotationType())) {
                im.addVerb(HttpMethod.VERB.HEAD);
            }
            if (!OPTIONS.class.isAssignableFrom(a.annotationType())) continue;
            im.addVerb(HttpMethod.VERB.OPTIONS);
        }
    }
}

