/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server;

import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.Transcription;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class Transcriber {
    Set<Transcription> transcriptions = new TreeSet<Transcription>(new Comparator<Transcription>(){

        @Override
        public int compare(Transcription o1, Transcription o2) {
            if (o1.getCreatedAt() < o2.getCreatedAt()) {
                return -1;
            }
            if (o1.getCreatedAt() > o2.getCreatedAt()) {
                return 1;
            }
            return 0;
        }
    });

    public void transcribe(HttpRequest request) {
        for (Transcription transcription : this.transcriptions) {
            if (!transcription.matches(request.getUri())) continue;
            if (transcription.isReplaceWholeRequest()) {
                request.setUri(transcription.getReplacementPath());
                break;
            }
            String newPath = transcription.isReplaceFirstOccurrence() ? transcription.replaceFirstMatch(request.getUri()) : transcription.replaceAllMatches(request.getUri());
            request.setUri(newPath);
            break;
        }
    }

    public void addTranscription(Transcription transcription) {
        this.transcriptions.add(transcription);
    }
}

