/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server;

import io.higgs.core.ResourcePath;
import io.higgs.http.server.params.FormFiles;
import io.higgs.http.server.params.FormParams;
import io.higgs.http.server.params.HttpCookie;
import io.higgs.http.server.params.HttpCookies;
import io.higgs.http.server.params.HttpFile;
import io.higgs.http.server.params.QueryParams;
import io.higgs.http.server.protocol.HttpProtocolConfiguration;
import io.higgs.http.server.resource.MediaType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.session.mgt.DefaultSessionContext;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest
extends DefaultHttpRequest {
    public static final String SID = "HS3-ID";
    protected static final AttributeKey<String> sessionAttr = new AttributeKey("HS3-ID-attr");
    protected final QueryParams queryParams = new QueryParams();
    protected final FormFiles files = new FormFiles();
    protected final FormParams form = new FormParams();
    protected final HttpCookies cookies = new HttpCookies();
    protected final DateTime createdAt = new DateTime();
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected ResourcePath path;
    protected List<MediaType> acceptedMediaTypes = new ArrayList<MediaType>();
    protected boolean newSession;
    protected String sessionId;
    protected MediaType matchedMediaType = MediaType.WILDCARD_TYPE;
    protected HttpProtocolConfiguration config;
    protected boolean multipart;
    protected boolean chunked;
    protected ByteBuf content = Unpooled.buffer((int)0);
    protected HttpCookie sessionCookie;
    protected List<MediaType> contentType;
    protected Session session;
    protected Subject subject;

    public HttpRequest(FullHttpRequest msg) {
        this(msg.getProtocolVersion(), msg.getMethod(), msg.getUri());
        this.headers().add(msg.headers());
        this.content = Unpooled.copiedBuffer((ByteBuf)msg.content());
        this.setDecoderResult(msg.getDecoderResult());
    }

    public HttpRequest(HttpVersion httpVersion, HttpMethod method, String uri) {
        super(httpVersion, method, uri);
    }

    public void init(ChannelHandlerContext ctx) {
        String contentTypeStr = this.headers().get("Content-Type");
        this.contentType = MediaType.valueOf(contentTypeStr);
        String accept = this.headers().get("Accept");
        this.acceptedMediaTypes = MediaType.valueOf(accept);
        String cookiesStr = this.headers().get("Cookie");
        if (cookiesStr != null) {
            Set cookie = CookieDecoder.decode((String)cookiesStr);
            for (Cookie c : cookie) {
                this.cookies.put(c.getName(), new HttpCookie(c));
            }
        }
        QueryStringDecoder decoderQuery = new QueryStringDecoder(this.getUri());
        this.queryParams.putAll(decoderQuery.parameters());
        this.initSession(ctx);
    }

    public void initSession(ChannelHandlerContext ctx) {
        HttpCookie sc = this.getCookie(SID);
        if (sc == null) {
            Attribute sessAttr = ctx.channel().attr(sessionAttr);
            if (sessAttr.get() != null) {
                sc = this.getCookie((String)sessAttr.get());
                this.sessionId = (String)sessAttr.get();
            }
        } else {
            this.sessionId = sc.getValue();
        }
        DefaultSessionKey sessionKey = new DefaultSessionKey((Serializable)((Object)this.sessionId));
        try {
            this.session = this.config.getSecurityManager().getSession((SessionKey)sessionKey);
        }
        catch (SessionException se) {
            this.session = null;
        }
        if (sc == null || this.session == null) {
            if (sc == null) {
                String sp;
                SecureRandom random = new SecureRandom();
                this.sessionId = new BigInteger(130, random).toString(32);
                HttpCookie sessionCookie = new HttpCookie(SID, this.sessionId);
                sessionCookie.setPath(this.config.getServer().getConfig().session_path);
                sessionCookie.setMaxAge(this.config.getServer().getConfig().session_max_age);
                sessionCookie.setHttpOnly(this.config.getServer().getConfig().session_http_only);
                if (this.config.getServer().getConfig().session_domain != null && !this.config.getServer().getConfig().session_domain.isEmpty()) {
                    sessionCookie.setDomain(this.config.getServer().getConfig().session_domain);
                }
                if ((sp = this.config.getServer().getConfig().session_ports) != null && !sp.isEmpty()) {
                    String[] ps = sp.split(",");
                    ArrayList<Integer> ports = new ArrayList<Integer>(ps.length);
                    for (String p : ps) {
                        try {
                            ports.add(Integer.parseInt(p));
                        }
                        catch (NumberFormatException nfe) {
                            this.log.warn(String.format("Session port config contained non-numeric value (%s)", p));
                        }
                    }
                    sessionCookie.setPorts(ports);
                }
                this.sessionCookie = sessionCookie;
                this.newSession = true;
            }
            Attribute sessAttr = ctx.channel().attr(sessionAttr);
            sessAttr.set((Object)this.sessionId);
            DefaultSessionContext sessionCtx = new DefaultSessionContext();
            sessionCtx.setSessionId((Serializable)((Object)this.sessionId));
            this.session = this.config.getSecurityManager().start((SessionContext)sessionCtx);
        }
        DefaultSubjectContext subjectCtx = new DefaultSubjectContext();
        subjectCtx.setSession(this.session);
        subjectCtx.setSecurityManager(this.config.getSecurityManager());
        this.subject = this.config.getSecurityManager().createSubject((SubjectContext)subjectCtx);
    }

    public HttpCookie getCookie(String name) {
        return (HttpCookie)((Object)this.cookies.get(name));
    }

    public List<MediaType> getContentType() {
        return this.contentType;
    }

    public List<MediaType> getAcceptedMediaTypes() {
        return this.acceptedMediaTypes;
    }

    public boolean isGet() {
        return HttpMethod.GET.name().equalsIgnoreCase(this.getMethod().name());
    }

    public boolean isPost() {
        return HttpMethod.POST.name().equalsIgnoreCase(this.getMethod().name());
    }

    public boolean isPut() {
        return HttpMethod.PUT.name().equalsIgnoreCase(this.getMethod().name());
    }

    public boolean isDelete() {
        return HttpMethod.DELETE.name().equalsIgnoreCase(this.getMethod().name());
    }

    public boolean isHead() {
        return HttpMethod.HEAD.name().equalsIgnoreCase(this.getMethod().name());
    }

    public boolean isOptions() {
        return HttpMethod.OPTIONS.name().equalsIgnoreCase(this.getMethod().name());
    }

    public ResourcePath getPath() {
        return this.path;
    }

    public void setPath(ResourcePath path) {
        this.path = path;
    }

    public HttpCookies getCookies() {
        return this.cookies;
    }

    public void setCookie(String name, String value) {
        HttpCookie cookie = new HttpCookie(name, value);
        cookie.setPath("/");
        this.setCookie(cookie);
    }

    public void setCookie(HttpCookie cookie) {
        this.cookies.put(cookie.getName(), cookie);
    }

    public boolean isNewSession() {
        return this.newSession;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public HttpCookie getSessionCookie() {
        return this.sessionCookie;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void addFormField(String name, Object value) {
        this.form.put(name, value);
    }

    public void addFormFile(HttpFile file) {
        this.files.put(file.getParameterName(), file);
    }

    public QueryParams getQueryParams() {
        return this.queryParams;
    }

    public FormFiles getFormFiles() {
        return this.files;
    }

    public FormParams getFormParam() {
        return this.form;
    }

    public String toString() {
        return "HttpRequest{newSession=" + this.newSession + ", acceptedMediaTypes=" + this.acceptedMediaTypes.size() + ", path=" + this.path + ", cookies=" + this.cookies.size() + ", form=" + this.form.size() + ", files=" + this.files.size() + ", queryParams=" + this.queryParams.size() + '}';
    }

    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public MediaType getMatchedMediaType() {
        return this.matchedMediaType;
    }

    public void setMatchedMediaType(MediaType matchedMediaType) {
        this.matchedMediaType = matchedMediaType;
    }

    public HttpProtocolConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(HttpProtocolConfiguration config) {
        this.config = config;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public void setMultipart(boolean multipart) {
        this.multipart = multipart;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public ByteBuf content() {
        return this.content;
    }
}

