/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.transformers;

import io.higgs.core.ResolvedFile;
import io.higgs.http.server.HttpRequest;
import io.higgs.http.server.HttpResponse;
import io.higgs.http.server.protocol.HttpMethod;
import io.higgs.http.server.resource.MediaType;
import io.higgs.http.server.transformers.ResponseTransformer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTransformer
implements ResponseTransformer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected int priority;
    protected Set<MediaType> supportedTypes = new HashSet<MediaType>();

    protected void setResponseContent(HttpResponse res, byte[] data) {
        if (data != null) {
            res.content().writeBytes(data);
            HttpHeaders.setContentLength((HttpMessage)res, (long)data.length);
        }
    }

    protected void determineErrorStatus(HttpResponse res, Throwable response) {
        HttpResponseStatus status = null;
        if (response == null) {
            status = HttpResponseStatus.NO_CONTENT;
        } else if (response instanceof WebApplicationException) {
            status = HttpResponseStatus.valueOf((int)((WebApplicationException)response).getResponse().getStatus());
        }
        res.setStatus(status);
    }

    public int setPriority(int value) {
        int old = this.priority;
        this.priority = value;
        return old;
    }

    public int priority() {
        return this.priority;
    }

    public int compareTo(ResponseTransformer that) {
        return that.priority() - this.priority();
    }

    @Override
    public boolean canTransform(Object response, HttpRequest request, MediaType mediaType, HttpMethod method, ChannelHandlerContext ctx) {
        if (method != null && method.hasProduces()) {
            return method.produces(this.supportedTypes.toArray(new MediaType[this.supportedTypes.size()]));
        }
        return this.mediaTypeMatches(request) && (this.isError(response) || !this.isStaticFileResponse(response));
    }

    public boolean mediaTypeMatches(HttpRequest request) {
        if (request == null) {
            return true;
        }
        for (MediaType type : request.getAcceptedMediaTypes()) {
            for (MediaType supportedType : this.supportedTypes) {
                if (!type.isCompatible(supportedType)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isError(Object response) {
        return response instanceof Throwable;
    }

    public boolean isStaticFileResponse(Object response) {
        return response instanceof File || response instanceof ResolvedFile || response instanceof InputStream || response instanceof Path;
    }

    public void addSupportedTypes(MediaType ... type) {
        if (type != null) {
            Collections.addAll(this.supportedTypes, type);
        }
    }
}

