/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.server.protocol;

import io.higgs.core.ProtocolDetector;
import io.higgs.http.server.HttpRequestDecoder;
import io.higgs.http.server.HttpResponseEncoder;
import io.higgs.http.server.protocol.HttpHandler;
import io.higgs.http.server.protocol.HttpProtocolConfiguration;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.stream.ChunkedWriteHandler;

public class HttpDetector
implements ProtocolDetector {
    protected final HttpProtocolConfiguration config;

    public HttpDetector(HttpProtocolConfiguration config) {
        this.config = config;
    }

    public boolean detected(ChannelHandlerContext ctx, ByteBuf in) {
        short magic1 = in.getUnsignedByte(in.readerIndex());
        short magic2 = in.getUnsignedByte(in.readerIndex() + 1);
        return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82 || magic1 == 67 && magic2 == 79;
    }

    public HttpHandler setupPipeline(ChannelPipeline p, ChannelHandlerContext ctx) {
        HttpHandler h = new HttpHandler(this.config);
        p.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        p.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        p.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        p.addLast("handler", (ChannelHandler)h);
        return h;
    }
}

