/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.client.readers;

import io.higgs.core.func.Function2;
import io.higgs.http.client.Response;
import io.higgs.http.client.readers.Reader;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class FileReader
extends Reader<File> {
    protected File file;
    protected FileOutputStream out;

    public FileReader() throws IOException {
        this((Function2<File, Response>)null);
    }

    public FileReader(Function2<File, Response> function) throws IOException {
        if (function != null) {
            this.listen(function);
        }
        this.file = Files.createTempFile("higgs-http-client-temp-" + new Double(Math.random()).longValue(), ".tmp", new FileAttribute[0]).toFile();
        this.out = new FileOutputStream(this.file);
    }

    @Override
    public void data(ByteBuf data) {
        byte[] tmp = new byte[data.readableBytes()];
        data.readBytes(tmp);
        try {
            this.out.write(tmp);
        }
        catch (IOException e) {
            this.log.warn("Error writing data to file", (Throwable)e);
        }
    }

    @Override
    public void done() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            this.log.warn("Unable to close output stream of the downloaded file", (Throwable)e);
        }
        for (Function2 function : this.functions) {
            function.apply((Object)this.file, (Object)this.response);
        }
    }
}

