/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.client;

import io.higgs.core.StaticUtil;
import io.higgs.core.func.Function1;
import io.higgs.http.client.ClientHandler;
import io.higgs.http.client.ClientIntializer;
import io.higgs.http.client.ConnectHandler;
import io.higgs.http.client.FutureResponse;
import io.higgs.http.client.HttpRequestBuilder;
import io.higgs.http.client.Response;
import io.higgs.http.client.RetryPolicy;
import io.higgs.http.client.readers.Reader;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;

public class Request<T extends Request<T>> {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    protected final Response response;
    protected final Map<String, Object> queryParams = new HashMap<String, Object>();
    protected final FutureResponse future;
    protected final EventLoopGroup group;
    protected final HttpMethod method;
    protected HttpRequest request;
    protected URI uri;
    protected Channel channel;
    protected String userAgent = "Mozilla/5.0 (compatible; HiggsBoson/0.0.1; +https://github.com/zcourts/higgs)";
    protected List<Cookie> cookies = new ArrayList<Cookie>();
    protected String proxyHost = HttpRequestBuilder.proxyHost;
    protected String proxyUser = HttpRequestBuilder.proxyUsername;
    protected String proxyPass = HttpRequestBuilder.proxyPassword;
    protected int proxyPort = HttpRequestBuilder.proxyPort;
    protected HttpVersion version;
    protected Set<Integer> redirectStatusCodes = new HashSet<Integer>();
    protected URI originalUri;
    protected DefaultFullHttpRequest proxyRequest;
    protected ChannelFuture connectFuture;
    protected boolean useSSL;
    protected boolean tunneling;
    protected String[] sslProtocols;
    protected final ByteBuf contents = Unpooled.buffer();
    protected T _this = this;
    protected Function1<Bootstrap> conf;
    protected RetryPolicy policy;
    private Set<Integer> retryOptions = new HashSet<Integer>();

    public Request(HttpRequestBuilder builder, EventLoopGroup group, URI uri, HttpMethod method, HttpVersion version, Reader responseReader) {
        if (responseReader == null) {
            throw new IllegalArgumentException("A response reader is required, can't process the response otherwise");
        }
        this.response = new Response(this, responseReader);
        this.deleteTempFileOnExit(true);
        this.baseDirectory(null);
        this.uri = uri;
        this.group = group;
        this.method = method;
        this.version = version;
        this.newNettyRequest(uri, method, version);
        this.future = new FutureResponse(group, this.response);
        for (int code : this.redirectStatusCodes) {
            this.redirectOn(code);
        }
        this.headers().set("Connection", (Object)builder.connectionHeader);
        this.headers().set("Accept-Encoding", (Object)builder.acceptedEncodings);
        this.headers().set("Accept-Charset", (Object)builder.charSet);
        this.headers().set("Accept-Language", (Object)builder.acceptedLanguages);
        this.headers().set("User-Agent", (Object)builder.userAgent);
        this.headers().set("Accept", (Object)builder.acceptedMimeTypes);
    }

    public void deleteTempFileOnExit(boolean delete) {
        DiskFileUpload.deleteOnExitTemporaryFile = delete;
    }

    public void baseDirectory(String baseDir) {
        DiskFileUpload.baseDirectory = baseDir;
    }

    protected void newNettyRequest(URI uri, HttpMethod method, HttpVersion version) {
        this.request = new DefaultFullHttpRequest(version, method, uri.getRawPath(), this.contents);
        this.headers().set("Referer", (Object)(this.originalUri == null ? uri.toString() : this.originalUri.toString()));
    }

    public T redirectOn(int ... codes) {
        for (int code : codes) {
            this.redirectStatusCodes.add(code);
        }
        return this._this;
    }

    public HttpHeaders headers() {
        return this.request.headers();
    }

    public Set<Integer> redirectOn() {
        return this.redirectStatusCodes;
    }

    public FutureResponse execute() {
        return this.execute(this.conf);
    }

    public FutureResponse execute(Function1<Bootstrap> conf) {
        String scheme = this.getScheme();
        String host = this.getHost();
        int port = this.uri.getPort();
        if (port == -1) {
            port = this.getPort(scheme);
            try {
                this.uri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), port, this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment());
            }
            catch (URISyntaxException e) {
                System.err.println(e.getMessage());
            }
        }
        boolean ssl = this.isSSLScheme(scheme);
        this.headers().set("Host", (Object)host);
        this.useSSL = ssl;
        try {
            this.configure();
            if (this.isProxyEnabled()) {
                host = this.proxyHost;
                port = this.proxyPort;
                this.configureProxy(ssl);
                if (this.tunneling) {
                    this.useSSL = false;
                }
            }
            Bootstrap bootstrap = new Bootstrap();
            if (conf != null) {
                this.conf = conf;
                conf.apply((Object)bootstrap);
            }
            ((Bootstrap)((Bootstrap)bootstrap.group(this.group)).channel(NioSocketChannel.class)).handler(this.newInitializer());
            this.connect(host, port, bootstrap);
            this.channel = this.connectFuture.channel();
            this.connectFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(ChannelFuture f) throws Exception {
                    if (f.isSuccess()) {
                        Request.this.makeTheRequest();
                    } else {
                        Request.this.retryOrFail(f.cause(), true);
                    }
                }
            });
        }
        catch (Throwable e) {
            this.retryOrFail(e, false);
        }
        return this.future;
    }

    public void retry() {
        this.execute();
    }

    protected void retryOrFail(Throwable cause, boolean connectFailure) {
        if (this.policy == null) {
            this.future.setFailure(cause);
        } else {
            this.policy.activate(this.future, cause, connectFailure, this.response);
        }
    }

    public T policy(RetryPolicy policy) {
        this.policy = policy;
        return this._this;
    }

    public Set<Integer> retryOn() {
        return this.retryOptions;
    }

    public T retryOn(int ... statusCodes) {
        for (int code : statusCodes) {
            this.retryOptions.add(code);
        }
        return this._this;
    }

    protected String getScheme() {
        return this.uri.getScheme() == null ? "http" : this.uri.getScheme();
    }

    protected String getHost() {
        return this.uri.getHost() == null ? "localhost" : this.uri.getHost();
    }

    protected int getPort(String scheme) {
        if (this.isSSLScheme(scheme)) {
            return 443;
        }
        return 80;
    }

    protected boolean isSSLScheme(String scheme) {
        return "https".equalsIgnoreCase(scheme);
    }

    protected void configure() throws Exception {
        String cookiesStr = ClientCookieEncoder.LAX.encode(this.cookies);
        if (cookiesStr != null) {
            this.headers().set("Cookie", (Object)cookiesStr);
        }
        QueryStringEncoder encoder = new QueryStringEncoder(this.uri.getRawPath());
        QueryStringDecoder decoder = new QueryStringDecoder(this.uri);
        for (Map.Entry entry : decoder.parameters().entrySet()) {
            if (entry.getKey() == null) continue;
            for (String val : (List)entry.getValue()) {
                if (entry.getKey() == null) continue;
                encoder.addParam((String)entry.getKey(), val == null ? "" : val);
            }
        }
        for (Map.Entry<Object, Object> entry : this.queryParams.entrySet()) {
            if (entry.getKey() == null || entry.getKey() == null) continue;
            encoder.addParam((String)entry.getKey(), entry.getValue() == null ? "" : entry.getValue().toString());
        }
        this.request.setUri(encoder.toString());
    }

    public boolean isProxyEnabled() {
        return this.proxyHost != null && !this.proxyHost.isEmpty();
    }

    protected void configureProxy(boolean ssl) {
        String authority = this.uri.getHost() + ":" + this.uri.getPort();
        if (ssl || this.tunneling || !HttpMethod.GET.equals((Object)this.method) && !HttpMethod.POST.equals((Object)this.method)) {
            this.proxyRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, authority);
            this.proxyRequest.headers().set("Host", (Object)authority);
            this.proxyRequest.headers().set("Connection", (Object)"keep-alive");
            this.proxyRequest.headers().set("Proxy-Connection", (Object)"keep-alive");
            this.tunneling = true;
        } else {
            String proxyURL = this.getProxyPath();
            this.request.setUri(proxyURL);
            this.request.headers().set("Host", (Object)(this.uri.getHost() == null ? "localhost" : this.uri.getHost()));
        }
        if (this.proxyUser != null && !this.proxyUser.isEmpty()) {
            String encoded = DatatypeConverter.printBase64Binary((byte[])(this.proxyUser + ":" + this.proxyPass).getBytes(UTF8));
            String auth = "Basic " + encoded;
            (this.proxyRequest == null ? this.request : this.proxyRequest).headers().set("Proxy-Authorization", (Object)auth);
        }
    }

    protected ChannelHandler newInitializer() {
        ConnectHandler.InitFactory factory = new ConnectHandler.InitFactory(){

            @Override
            public ClientIntializer newInstance(boolean ssl, SimpleChannelInboundHandler<Object> handler, ConnectHandler h) {
                return new ClientIntializer(ssl, (ChannelHandler)handler, h, Request.this.sslProtocols);
            }
        };
        return new ClientIntializer(this.useSSL, (ChannelHandler)this.newHandler(), this.isProxyEnabled() && this.proxyRequest != null ? new ConnectHandler(this.tunneling, this.request, this.newHandler(), factory) : null, this.sslProtocols);
    }

    protected ChannelFuture connect(String host, int port, Bootstrap bootstrap) {
        this.connectFuture = bootstrap.connect(host, port);
        return this.connectFuture;
    }

    protected ChannelFuture makeTheRequest() {
        if (this.isProxyEnabled() && this.proxyRequest != null) {
            return StaticUtil.write((Channel)this.channel, (Object)this.proxyRequest);
        }
        return StaticUtil.write((Channel)this.channel, (Object)this.request);
    }

    protected String getProxyPath() {
        return this.getScheme() + "://" + this.uri.getHost() + this.request.getUri();
    }

    protected SimpleChannelInboundHandler<Object> newHandler() {
        return new ClientHandler(this.response, this.future, this.policy);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public T proxy(String host, int port) {
        return this.proxy(host, port, null, null);
    }

    public T proxy(String host, int port, String username, String password) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.proxyUser = username;
        this.proxyPass = password;
        return this._this;
    }

    public T userAgent(String agent) {
        if (agent != null) {
            this.userAgent = agent;
        }
        return this._this;
    }

    public T header(String name, Object value) {
        this.headers().set(name, value);
        return this._this;
    }

    public T header(String name, Iterable<?> value) {
        this.headers().set(name, value);
        return this._this;
    }

    public T header(String name, String value) {
        this.headers().set(name, (Object)value);
        return this._this;
    }

    public T query(String name, Object value) {
        this.queryParams.put(name, value);
        return this._this;
    }

    public T cookie(Cookie cookie) {
        if (cookie != null) {
            this.cookies.add(cookie);
        }
        return this._this;
    }

    public T cookie(String name, Object value) {
        if (name != null) {
            DefaultCookie cookie = new DefaultCookie(name, value == null ? null : value.toString());
            this.cookies.add((Cookie)cookie);
        }
        return this._this;
    }

    public List<Cookie> cookies() {
        return this.cookies;
    }

    public void shutdown() {
        this.group.shutdownGracefully();
    }

    public Response response() {
        return this.response;
    }

    public URI originalUri() {
        return this.originalUri;
    }

    public URI url() {
        return this.uri;
    }

    public T url(String url) throws URISyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("NULL url provided");
        }
        this.originalUri = this.uri;
        this.uri = url.startsWith(this.getScheme()) ? new URI(url) : this.uri.resolve(url);
        this.newNettyRequest(this.uri, this.method, this.version);
        return this._this;
    }

    public HttpRequest nettyRequest() {
        return this.request;
    }

    public T withSSLProtocols(String[] protocols) {
        if (protocols == null || protocols.length == 0) {
            throw new IllegalArgumentException("At least one SSL protocol must be enabled");
        }
        this.sslProtocols = protocols;
        return this._this;
    }
}

