/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.client;

import io.higgs.core.StaticUtil;
import io.higgs.http.client.HttpFile;
import io.higgs.http.client.HttpRequestBuilder;
import io.higgs.http.client.Request;
import io.higgs.http.client.readers.Reader;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class POST
extends Request {
    private final List<HttpFile> files = new ArrayList<HttpFile>();
    protected long minSize = 16384L;
    private HttpPostRequestEncoder encoder;
    private Map<String, Object> form = new HashMap<String, Object>();
    private HttpDataFactory factory;

    public POST(HttpRequestBuilder builder, EventLoopGroup group, URI uri, HttpVersion version, Reader f) {
        super(builder, group, uri, HttpMethod.POST, version, f);
    }

    @Override
    protected void configure() throws Exception {
        super.configure();
        boolean multipart = this.files.size() > 0;
        this.newEncoder(multipart);
        this.addFormParams();
        if (multipart) {
            this.addFileParams();
        }
        this.request = this.encoder.finalizeRequest();
    }

    @Override
    protected ChannelFuture makeTheRequest() {
        return !this.encoder.isChunked() ? super.makeTheRequest() : this.doRequest();
    }

    private ChannelFuture doRequest() {
        StaticUtil.write((Channel)this.channel, (Object)this.request);
        return StaticUtil.write((Channel)this.channel, (Object)this.encoder).awaitUninterruptibly().addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

            public void operationComplete(Future<Void> future) throws Exception {
                POST.this.encoder.cleanFiles();
            }
        });
    }

    protected void newEncoder(boolean multipart) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        this.factory = new DefaultHttpDataFactory(this.minSize);
        this.encoder = new HttpPostRequestEncoder(this.factory, this.request, multipart);
    }

    private void addFormParams() throws HttpPostRequestEncoder.ErrorDataEncoderException {
        for (Map.Entry<String, Object> e : this.form.entrySet()) {
            this.encoder.addBodyAttribute(e.getKey(), String.valueOf(e.getValue() == null ? "" : e.getValue()));
        }
    }

    private void addFileParams() throws HttpPostRequestEncoder.ErrorDataEncoderException {
        for (HttpFile file : this.files) {
            if (file.isSingle()) {
                this.encoder.addBodyFileUpload(file.name(), file.file(), file.contentType(), file.isText());
                continue;
            }
            this.encoder.addBodyFileUploads(file.name(), file.fileSet(), file.contentTypes(), file.isTextSet());
        }
    }

    public long getMinSize() {
        return this.minSize;
    }

    public POST setMinSize(long minSize) {
        this.minSize = minSize;
        return this;
    }

    public List<HttpFile> getFiles() {
        return this.files;
    }

    public HttpPostRequestEncoder getEncoder() {
        return this.encoder;
    }

    public Map<String, Object> getForm() {
        return this.form;
    }

    public HttpDataFactory getFactory() {
        return this.factory;
    }

    public POST form(String name, Object value) {
        this.form.put(name, value);
        return this;
    }

    public POST file(HttpFile file) {
        if (file != null) {
            this.files.add(file);
        }
        return this;
    }
}

