/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.client;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;

public class HttpFile {
    private final String name;
    private List<File> files = new ArrayList<File>();
    private List<String> contentTypes = new ArrayList<String>();
    private List<Boolean> texts = new ArrayList<Boolean>();
    private MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();

    public HttpFile(String name, File file) {
        this(name);
        this.addFile(file);
    }

    public HttpFile(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot create an HttpFile with null as the name");
        }
        this.name = name;
    }

    public HttpFile addFile(File file) {
        return this.addFile(file, false);
    }

    public HttpFile addFile(File file, boolean isText) {
        this.texts.add(this.texts.size(), isText);
        this.contentTypes.add(this.contentTypes.size(), this.mimeTypesMap.getContentType(file.getPath()));
        this.files.add(this.files.size(), file);
        return this;
    }

    public boolean isSingle() {
        return this.files.size() == 1;
    }

    public String name() {
        return this.name;
    }

    public File file() {
        return this.files.get(0);
    }

    public String contentType() {
        return this.contentTypes.get(0);
    }

    public boolean isText() {
        return this.texts.get(0);
    }

    public File[] fileSet() {
        return this.files.toArray(new File[this.files.size()]);
    }

    public String[] contentTypes() {
        return this.contentTypes.toArray(new String[this.contentTypes.size()]);
    }

    public boolean[] isTextSet() {
        boolean[] prim = new boolean[this.texts.size()];
        for (int i = 0; i < this.texts.size(); ++i) {
            boolean b;
            prim[i] = b = this.texts.get(i).booleanValue();
        }
        return prim;
    }
}

