/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.http.client;

import io.higgs.core.ssl.SSLConfigFactory;
import io.higgs.core.ssl.SSLConfiguration;
import io.higgs.core.ssl.SSLContextFactory;
import io.higgs.http.client.ConnectHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import javax.net.ssl.SSLEngine;

public class ClientIntializer
extends ChannelInitializer<SocketChannel> {
    protected final boolean ssl;
    protected final ConnectHandler connectHandler;
    protected final ChannelHandler handler;
    protected final String[] sslProtocols;

    public ClientIntializer(boolean ssl, ChannelHandler handler, ConnectHandler connectHandler, String[] sslProtocols) {
        this.ssl = ssl;
        this.handler = handler;
        this.connectHandler = connectHandler;
        this.sslProtocols = sslProtocols;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        this.configurePipeline(pipeline);
    }

    public void configurePipeline(ChannelPipeline pipeline) {
        if (this.ssl) {
            ClientIntializer.addSSL(pipeline, false, this.sslProtocols);
        }
        if (pipeline.get("codec") == null) {
            pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec());
        } else {
            pipeline.replace("codec", "codec", (ChannelHandler)new HttpClientCodec());
        }
        if (pipeline.get("inflater") == null) {
            pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
        } else {
            pipeline.replace("inflater", "inflater", (ChannelHandler)new HttpContentDecompressor());
        }
        if (pipeline.get("chunkedWriter") == null) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        } else {
            pipeline.replace("chunkedWriter", "chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (pipeline.get("handler") == null) {
            pipeline.addLast("handler", (ChannelHandler)(this.connectHandler == null ? this.handler : this.connectHandler));
        } else {
            pipeline.replace("handler", "handler", (ChannelHandler)(this.connectHandler == null ? this.handler : this.connectHandler));
        }
    }

    public static void addSSL(ChannelPipeline pipeline, boolean forceToFront, String[] sslProtocols) {
        SSLEngine engine = SSLContextFactory.getSSLSocket((SSLConfiguration)SSLConfigFactory.sslConfiguration).createSSLEngine();
        engine.setUseClientMode(true);
        if (sslProtocols != null && sslProtocols.length > 0) {
            engine.setEnabledProtocols(sslProtocols);
        }
        if (forceToFront) {
            pipeline.addFirst("ssl", (ChannelHandler)new SslHandler(engine));
        } else {
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        }
    }
}

