/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.examples.websocketClient;

import io.higgs.http.client.HttpRequestBuilder;
import io.higgs.ws.client.WebSocketClient;
import io.higgs.ws.client.WebSocketEventListener;
import io.higgs.ws.client.WebSocketMessage;
import io.higgs.ws.client.WebSocketStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;

public final class WebSocketDemo
implements WebSocketEventListener {
    private final WebSocketStream stream;

    private WebSocketDemo(WebSocketStream stream) {
        this.stream = stream;
    }

    public static void main(String ... args) throws URISyntaxException {
        WebSocketClient.maxFramePayloadLength = 0xC80000;
        WebSocketStream stream = WebSocketClient.connect((URI)new URI("ws://websocket.datasift.com/multi?username=zcourts&api_key=bc753994e3b3630556c7cf5c3f600d70"), (boolean)true, (String[])HttpRequestBuilder.getSupportedSSLProtocols());
        stream.subscribe((WebSocketEventListener)new WebSocketDemo(stream));
    }

    public void onConnect(ChannelHandlerContext ctx) {
        this.stream.send("{ \"action\" : \"subscribe\" , \"hash\": \"13e9347e7da32f19fcdb08e297019d2e\"}");
    }

    public void onClose(ChannelHandlerContext ctx, CloseWebSocketFrame frame) {
        System.out.println("DISCONNECTED:" + frame.reasonText());
    }

    public void onPing(ChannelHandlerContext ctx, PingWebSocketFrame frame) {
        System.out.println("PING:" + frame.content().toString(Charset.forName("utf8")));
    }

    public void onMessage(ChannelHandlerContext ctx, WebSocketMessage msg) {
        System.out.println("MESSAGE:" + msg.data());
    }

    public void onError(ChannelHandlerContext ctx, Throwable cause, FullHttpResponse response) {
        System.out.println("Error:" + response);
        if (cause != null) {
            cause.printStackTrace();
        }
    }
}

