/*
 * Decompiled with CFR 0.152.
 */
package io.higgs.examples.httpClient;

import io.higgs.core.func.Function2;
import io.higgs.http.client.HttpFile;
import io.higgs.http.client.HttpRequestBuilder;
import io.higgs.http.client.JSONRequest;
import io.higgs.http.client.Request;
import io.higgs.http.client.Response;
import io.higgs.http.client.readers.FileReader;
import io.higgs.http.client.readers.LineReader;
import io.higgs.http.client.readers.PageReader;
import io.higgs.http.client.readers.Reader;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Demo {
    private static HttpRequestBuilder defaults = new HttpRequestBuilder();
    private static Logger log = LoggerFactory.getLogger(Demo.class);

    private Demo() {
        defaults.acceptedLanguages("en,fr").acceptedMimeTypes("text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8").charSet("ISO-8859-1,utf-8;q=0.7,*;q=0.7").userAgent("Mozilla/5.0 (compatible; HiggsBoson/0.0.1; +https://github.com/zcourts/higgs)").connection("close").redirectOn(new int[]{301, 302, 303, 307, 308});
    }

    public static void main(String[] args) throws Exception {
        ((JSONRequest)((JSONRequest)HttpRequestBuilder.instance().postJSON(new URI("http://httpbin.org/post"), (Reader)new PageReader((Function2)new Function2<String, Response>(){

            public void apply(String s, Response response) {
                System.out.println(s);
                HttpRequestBuilder.shutdown();
            }
        })).header("Authorization", "user:api-key")).header("Content-Type", "application/json")).addField("hash", (Object)"4cba32634b32ccd10528e4597913d5b2").addField("parameters", new ArrayList()).addField("filter", (Object)"f").addField("start", (Object)(System.currentTimeMillis() / 1000L - 86400L)).addField("end", (Object)(System.currentTimeMillis() / 1000L)).execute();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
            }
        });
        Request req3 = HttpRequestBuilder.instance().GET(new URI("https://api.datasift.com/v1.1/dpu"), (Reader)new PageReader((Function2)new Function2<String, Response>(){

            public void apply(String s, Response response) {
                System.out.println(s);
                HttpRequestBuilder.shutdown();
            }
        })).withSSLProtocols(new String[]{"SSLv3", "TLSv1"});
        HttpRequestBuilder.getSupportedSSLProtocols();
        HttpRequestBuilder.isSupportedSSLProtocol((String)"SSLv3");
        req3.execute();
        HttpRequestBuilder clone = defaults.copy();
        Request req = clone.GET(new URI("http://httpbin.org/relative-redirect/1"), (Reader)new PageReader((Function2)new Function2<String, Response>(){

            public void apply(String s, Response response) {
                System.out.println(s);
            }
        }));
        req.execute();
        Request r = clone.GET(new URI("http://httpbin.org/redirect/1"), (Reader)new PageReader((Function2)new Function2<String, Response>(){

            public void apply(String s, Response response) {
                System.out.println(s);
                System.out.println(response);
            }
        }));
        r.execute();
        r.url("/get").execute();
        PageReader page = new PageReader();
        page.listen((Function2)new Function2<String, Response>(){

            public void apply(String data, Response response) {
                System.out.println("----------------------------------- SIMPLE GET ----------------------------------");
                System.out.println(data);
            }
        });
        Request request = defaults.copy().GET(new URI("http://httpbin.org/get"), (Reader)page);
        Response response = request.response();
        request.header("some-header", "it's value").cookie("cookie-name", (Object)"cookie value");
        request.execute().addListener((GenericFutureListener)new GenericFutureListener<Future<Response>>(){

            public void operationComplete(Future<Response> future) throws Exception {
            }
        });
        LineReader lineReader = new LineReader((Function2)new Function2<String, Response>(){

            public void apply(String line, Response response) {
                System.out.println("LINE: " + line);
            }
        });
        defaults.GET(new URI("http://httpbin.org/get"), (Reader)lineReader).execute();
        FileReader fileReader = new FileReader((Function2)new Function2<File, Response>(){

            public void apply(File file, Response response) {
                System.out.println("--------------------------------- DOWNLOAD FILE ---------------------------------");
                System.out.print("NAME:");
                System.out.println(file.getName());
                System.out.print("PATH:");
                System.out.println(file.getPath());
                System.out.print("SIZE:");
                System.out.println(file.getTotalSpace());
            }
        });
        defaults.GET(new URI("https://codeload.github.com/zcourts/higgs/zip/master"), (Reader)fileReader).execute();
        PageReader post = new PageReader((Function2)new Function2<String, Response>(){

            public void apply(String data, Response response) {
                System.out.println("------------------------------- URL-ENCODED POST --------------------------------");
                System.out.println(data);
            }
        });
        defaults.POST(new URI("http://httpbin.org/post"), (Reader)post).form("abc", (Object)123).form("def", (Object)456).header("haha", "yup").execute();
        PageReader postReader = new PageReader((Function2)new Function2<String, Response>(){

            public void apply(String data, Response response) {
                System.out.println("----------------------------------- MULTIPART -----------------------------------");
                System.out.println(data);
            }
        });
        File tmpFile = Files.createTempFile("upload", ".txt", new FileAttribute[0]).toFile();
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile));
        writer.write("This is a temporary text file");
        HttpFile file = new HttpFile("the-file-name-param");
        file.addFile(tmpFile, true);
        Request p = defaults.POST(new URI("http://httpbin.org/post"), (Reader)postReader).file(file).form("abc", (Object)123).header("haha", "yup");
        p.execute().addListener((GenericFutureListener)new GenericFutureListener<Future<Response>>(){

            public void operationComplete(Future<Response> future) throws Exception {
                System.out.println(future.getNow());
                if (!future.isSuccess()) {
                    log.warn("ummo", future.cause());
                }
            }
        });
    }
}

