/*
 * Decompiled with CFR 0.152.
 */
package heretical.parser.common;

import heretical.parser.common.expression.Expression;
import java.util.ArrayList;
import java.util.List;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.errors.ParseError;
import org.parboiled.support.ParsingResult;

public class Result<E extends Expression> {
    private final ParsingResult<E> result;
    private final long parseDuration;

    public Result(ParsingResult<E> result, long parseDuration) {
        this.result = result;
        this.parseDuration = parseDuration;
    }

    public ParsingResult<E> getParsingResult() {
        return this.result;
    }

    public long getParseDuration() {
        return this.parseDuration;
    }

    public boolean matched() {
        return this.result.matched;
    }

    public boolean hasErrors() {
        return this.result.hasErrors();
    }

    public E getExpression() {
        return (E)((Expression)this.result.resultValue);
    }

    public int getNumErrors() {
        if (!this.result.hasErrors()) {
            return 0;
        }
        return this.result.parseErrors.size();
    }

    public int getErrorStartIndex(int index) {
        if (!this.result.hasErrors()) {
            throw new IllegalStateException("has no errors");
        }
        return ((ParseError)this.result.parseErrors.get(index)).getStartIndex();
    }

    public int getErrorEndIndex(int index) {
        if (!this.result.hasErrors()) {
            throw new IllegalStateException("has no errors");
        }
        return ((ParseError)this.result.parseErrors.get(index)).getEndIndex();
    }

    public List<String> getErrorMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        for (ParseError parseError : this.result.parseErrors) {
            messages.add(parseError.getErrorMessage());
        }
        return messages;
    }

    public String prettyPrintErrors() {
        return ErrorUtils.printParseErrors(this.result);
    }
}

