/*
 * Decompiled with CFR 0.152.
 */
package heretical.parser.common;

import heretical.parser.common.Result;
import java.util.List;
import org.parboiled.errors.DefaultInvalidInputErrorFormatter;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.errors.ParseError;

public class ParserSyntaxException
extends RuntimeException {
    public static final String SEARCH_PARSE_ERROR = "parser syntax error";
    private final Result<?> result;
    private final List<String> errorMessages;
    private static final DefaultInvalidInputErrorFormatter formatter = new DefaultInvalidInputErrorFormatter();

    public ParserSyntaxException(Result<?> result) {
        super(ParserSyntaxException.makeMessage(result));
        this.result = result;
        this.errorMessages = result.getErrorMessages();
    }

    public ParserSyntaxException(List<String> errorMessages) {
        super(ParserSyntaxException.makeMessage(errorMessages));
        this.result = null;
        this.errorMessages = errorMessages;
    }

    public String getSyntaxError() {
        if (this.result == null) {
            return null;
        }
        return ParserSyntaxException.getSyntaxError(this.result);
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public List<ParseError> getParserErrorObjects() {
        if (this.result == null) {
            return null;
        }
        return this.result.getParsingResult().parseErrors;
    }

    public static String getErrorMessage(ParseError error) {
        if (error.getErrorMessage() != null) {
            return error.getErrorMessage();
        }
        if (error instanceof InvalidInputError) {
            return formatter.format((InvalidInputError)error);
        }
        return error.getClass().getSimpleName();
    }

    private static String makeMessage(Result result) {
        String errors = ParserSyntaxException.getSyntaxError(result);
        return String.format("%s: %s", SEARCH_PARSE_ERROR, errors);
    }

    private static String getSyntaxError(Result<?> result) {
        return ErrorUtils.printParseErrors(result.getParsingResult());
    }

    public static String makeMessage(List<String> errorMessages) {
        if (errorMessages == null || errorMessages.isEmpty() || ParserSyntaxException.isEmpty(errorMessages.get(0))) {
            return SEARCH_PARSE_ERROR;
        }
        return "parser syntax error: " + errorMessages.get(0);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

