package io.hellgate.android.sdk.handler

import io.hellgate.android.sdk.element.additionaldata.DataField
import io.hellgate.android.sdk.element.card.CardNumberField
import io.hellgate.android.sdk.element.cvc.CvcNumberField
import io.hellgate.android.sdk.element.exiprydate.ExpiryDateField
import io.hellgate.android.sdk.model.CardData
import io.hellgate.android.sdk.model.TokenizeCardResponse
import io.hellgate.android.sdk.service.ITokenService

interface CardHandler {
    suspend fun tokenizeCard(
        cardNumberField: CardNumberField,
        cvcNumberField: CvcNumberField,
        expiryDateField: ExpiryDateField,
        additionalData: List<DataField> = emptyList()
    ): TokenizeCardResponse
}

/**
 * Create a card handler and inject a token service
 */
internal fun initCardHandler(
    tokenService: ITokenService,
    sessionId: String,
) = object : CardHandler {
    override suspend fun tokenizeCard(

        cardNumberField: CardNumberField,
        cvcNumberField: CvcNumberField,
        expiryDateField: ExpiryDateField,
        additionalData: List<DataField>
    ): TokenizeCardResponse {
        val cardNumber = cardNumberField.validatedValue()?.value
        if (cardNumber.isNullOrEmpty()) return TokenizeCardResponse.Failure("Invalid card number")

        val fourDigitDate = expiryDateField.value()
        val month = fourDigitDate.take(2)
        val year = fourDigitDate.takeLast(2)
        val cardData = CardData(
            cardNumber = cardNumber,
            year = year,
            month = month,
            cvc = cvcNumberField.value()
        )

        return tokenService.tokenize(
            sessionId,
            cardData,
            additionalData.associate { it.additionalDataTypes to it.value() }
        )
    }
}
