package io.hellgate.android.sdk.client.hellgate

import com.fasterxml.jackson.annotation.JsonProperty
import io.hellgate.android.sdk.element.additionaldata.AdditionalDataTypes

internal data class SessionInformation(
    val data: Data?,
    val nextAction: NextAction?,
    val status: String?
) {
    // TODO add Jackson annotations for polymorphic deserialization

    data class Data(
        val btApiKey: String?
    )
}

internal enum class NextAction {
    @JsonProperty("tokenize_card")
    TOKENIZE_CARD,

    @JsonProperty("3ds_check")
    TDS_CHECK,

    @JsonProperty("3ds_challenge")
    TDS_CHALLENGE,

    @JsonProperty("3ds_decoupled")
    TDS_DECOUPLED,

    @JsonProperty("wait")
    WAIT,
}

internal data class SessionCompleteTokenizeCard(
    val action: String = "tokenize_card",
    val result: Result
) {
    data class Result(
        val btTokenId: String,
        val additionalData: AdditionalData?
    )

    data class AdditionalData(
        @JsonProperty("cardholder_name")
        val cardholderName: String?,
    ) {
        companion object {
            fun Map<AdditionalDataTypes, String>.toDTO() = AdditionalData(this[AdditionalDataTypes.CARDHOLDER_NAME])
        }
    }
}

internal data class SessionCompleteResponse(
    val data: Data,
    val status: String
) {
    data class Data(
        val tokenId: String
    )
}
