package io.hellgate.android.sdk

import io.hellgate.android.sdk.client.hellgate.NextAction

@Deprecated("This is a mock class for testing purposes")
internal object Mock {
    val scenario: MockScenario = MockScenario.TDS()
}

@Deprecated("This is a mock class for testing purposes")
object PublicMock {
    val name = Mock.scenario.name
}

@Deprecated("This is a mock class for testing purposes")
internal interface Scenario {
    val state: SessionState
    val nextAction: NextAction?
    fun progressScenario()
    val name: String
}

@Deprecated("This is a mock class for testing purposes")
@Suppress("MagicNumber")
internal sealed class MockScenario : Scenario {
    // NOT needed since api acutally does this
    class TokenizeCard : MockScenario() {
        override val state: SessionState
            get() = TODO("Not yet implemented")
        override val nextAction: NextAction
            get() = TODO("Not yet implemented")

        override fun progressScenario() {
            TODO("Not yet implemented")
        }

        override val name: String = "TokenizeCard"
    }

    class TDS : MockScenario() {
        override val name: String = "TDS"
        override var state: SessionState = SessionState.REQUIRE_TOKENIZATION
            private set
        override var nextAction: NextAction? = NextAction.TOKENIZE_CARD
            private set

        private var stateCounter = 0

        override fun progressScenario() {
            when (stateCounter) {
                in 0..3 -> {
                    state = SessionState.WAITING
                    nextAction = NextAction.WAIT
                    stateCounter++
                }
                4 -> {
                    state = SessionState.REQUIRE_3DS
                    nextAction = NextAction.TDS_CHECK
                    stateCounter++
                }
                in 5..8 -> {
                    nextAction = NextAction.WAIT
                    state = SessionState.WAITING
                    stateCounter++
                }
                9 -> {
                    state = SessionState.COMPLETED
                    nextAction = null
                    stateCounter = 0
                }
                else -> {
                    state = SessionState.WAITING
                    nextAction = NextAction.WAIT
                }
            }
        }
    }

    class Waiting : MockScenario() {
        override val name: String = "Waiting"
        override val state: SessionState = SessionState.WAITING
        override val nextAction: NextAction = NextAction.WAIT
        override fun progressScenario() {
            // no-op
        }
    }
}
