/*
 * Decompiled with CFR 0.152.
 */
package io.helins.linux.i2c;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import io.helins.linux.NativeMemory;
import io.helins.linux.i2c.I2CBus;
import io.helins.linux.i2c.internal.NativeI2CSmbusIoctlData;
import io.helins.linux.io.LinuxIO;
import java.io.IOException;

public class SMBus {
    private static final NativeLong I2C_PEC = new NativeLong(1800L, true);
    private static final NativeLong I2C_SMBUS = new NativeLong(1824L, true);
    private static final byte I2C_SMBUS_READ = 1;
    private static final byte I2C_SMBUS_WRITE = 0;
    private static final byte I2C_SMBUS_QUICK = 0;
    private static final byte I2C_SMBUS_BYTE = 1;
    private static final byte I2C_SMBUS_BYTE_DATA = 2;
    private static final byte I2C_SMBUS_WORD_DATA = 3;
    private static final byte I2C_SMBUS_PROC_CALL = 4;
    private static final byte I2C_SMBUS_BLOCK_DATA = 5;
    private static final byte I2C_SMBUS_I2C_BLOCK_BROKEN = 6;
    private static final byte I2C_SMBUS_BLOCK_PROC_CALL = 7;
    private static final byte I2C_SMBUS_I2C_BLOCK_DATA = 8;
    private final I2CBus bus;
    private final Memory i2cSmbusIoctlData;
    private final Memory i2cSmbusData;

    SMBus(I2CBus bus) {
        this.bus = bus;
        this.i2cSmbusIoctlData = new Memory((long)NativeI2CSmbusIoctlData.SIZE);
        this.i2cSmbusData = new Memory(34L);
        this.i2cSmbusIoctlData.clear();
        this.i2cSmbusData.clear();
    }

    public void usePEC(boolean usePEC) throws IOException {
        this.bus.guardClosed();
        if (LinuxIO.ioctl((int)this.bus.fd, (NativeLong)I2C_PEC, (long)(usePEC ? 1L : 0L)) < 0) {
            throw new IOException("Native error while setting PEC : errno " + I2CBus.getErrno());
        }
    }

    private int i2cSmbusAccess(byte readWrite, int command, int size, Pointer data) throws IOException {
        this.i2cSmbusIoctlData.setByte((long)NativeI2CSmbusIoctlData.OFFSET_READ_WRITE, readWrite);
        this.i2cSmbusIoctlData.setByte((long)NativeI2CSmbusIoctlData.OFFSET_COMMAND, (byte)command);
        this.i2cSmbusIoctlData.setInt((long)NativeI2CSmbusIoctlData.OFFSET_SIZE, size);
        this.i2cSmbusIoctlData.setPointer((long)NativeI2CSmbusIoctlData.OFFSET_DATA, data);
        int result = LinuxIO.ioctl((int)this.bus.fd, (NativeLong)I2C_SMBUS, (Pointer)this.i2cSmbusIoctlData);
        if (result < 0) {
            throw new IOException("Native error during SMBus operation : errno " + I2CBus.getErrno());
        }
        return result;
    }

    public void quick(boolean isWrite) throws IOException {
        this.bus.guardClosed();
        this.i2cSmbusAccess(isWrite ? (byte)0 : 1, 0, 0, null);
    }

    public int readByteDirectly() throws IOException {
        this.bus.guardClosed();
        this.i2cSmbusAccess((byte)1, 0, 1, (Pointer)this.i2cSmbusData);
        return NativeMemory.getUnsignedByte((Pointer)this.i2cSmbusData, (long)0L);
    }

    public int readByte(int command) throws IOException {
        this.bus.guardClosed();
        this.i2cSmbusAccess((byte)1, command, 2, (Pointer)this.i2cSmbusData);
        return NativeMemory.getUnsignedByte((Pointer)this.i2cSmbusData, (long)0L);
    }

    public int readWord(int command) throws IOException {
        this.bus.guardClosed();
        this.i2cSmbusAccess((byte)1, command, 3, (Pointer)this.i2cSmbusData);
        return NativeMemory.getUnsignedShort((Pointer)this.i2cSmbusData, (long)0L);
    }

    public int readBlock(int command, Block block) throws IOException {
        this.bus.guardClosed();
        this.i2cSmbusAccess((byte)1, command, 5, (Pointer)block.memory);
        return block.readLength();
    }

    public void readI2CBlock(int command, Block block, int length) throws IOException {
        this.bus.guardClosed();
        if (length > 32) {
            throw new IllegalArgumentException("Too many bytes requested.");
        }
        block.writeLength(length);
        this.i2cSmbusAccess((byte)1, command, length == 32 ? 6 : 8, (Pointer)block.memory);
        block.readLength();
    }

    public void writeByteDirectly(int b) throws IOException {
        this.bus.guardClosed();
        this.i2cSmbusAccess((byte)0, b, 1, null);
    }

    public void writeByte(int command, int b) throws IOException {
        this.bus.guardClosed();
        NativeMemory.setUnsignedByte((Pointer)this.i2cSmbusData, (long)0L, (int)b);
        this.i2cSmbusAccess((byte)0, command, 2, (Pointer)this.i2cSmbusData);
    }

    public void writeWord(int command, int word) throws IOException {
        this.bus.guardClosed();
        NativeMemory.setUnsignedShort((Pointer)this.i2cSmbusData, (long)0L, (int)word);
        this.i2cSmbusAccess((byte)0, command, 3, (Pointer)this.i2cSmbusData);
    }

    public void writeBlock(int command, Block block) throws IOException {
        this.bus.guardClosed();
        block.writeLength();
        this.i2cSmbusAccess((byte)0, command, 8, (Pointer)block.memory);
    }

    public void writeI2CBlock(int command, Block block) throws IOException {
        this.bus.guardClosed();
        block.writeLength();
        this.i2cSmbusAccess((byte)0, command, 6, (Pointer)block.memory);
    }

    public int processCall(int command, int word) throws IOException {
        this.bus.guardClosed();
        NativeMemory.setUnsignedShort((Pointer)this.i2cSmbusData, (long)0L, (int)word);
        this.i2cSmbusAccess((byte)0, command, 4, (Pointer)this.i2cSmbusData);
        return NativeMemory.getUnsignedShort((Pointer)this.i2cSmbusData, (long)0L);
    }

    public int blockProcessCall(int command, Block block) throws IOException {
        return this.blockProcessCall(command, block, block);
    }

    public int blockProcessCall(int command, Block blockWrite, Block blockRead) throws IOException {
        Block block;
        blockWrite.writeLength();
        if (blockWrite == blockRead) {
            block = blockWrite;
        } else {
            NativeMemory.copy((Memory)blockWrite.memory, (Pointer)blockRead.memory);
            block = blockRead;
        }
        this.i2cSmbusAccess((byte)0, command, 7, (Pointer)block.memory);
        return block.readLength();
    }

    public static class Block {
        public static final int SIZE = 32;
        private int length;
        final Memory memory = new Memory(35L);

        public Block() {
            this.memory.clear();
        }

        public Block clear() {
            this.memory.clear();
            this.length = 0;
            return this;
        }

        public int length() {
            return this.length;
        }

        int readLength() {
            this.length = NativeMemory.getUnsignedByte((Pointer)this.memory, (long)0L);
            return this.length;
        }

        void writeLength() {
            this.writeLength(this.length);
        }

        void writeLength(int length) {
            NativeMemory.setUnsignedByte((Pointer)this.memory, (long)0L, (int)length);
            this.length = length;
        }

        public int get(int index) {
            return NativeMemory.getUnsignedByte((Pointer)this.memory, (long)(index + 1));
        }

        public Block set(int index, int b) {
            NativeMemory.setUnsignedByte((Pointer)this.memory, (long)(++index), (int)b);
            this.length = Math.max(this.length, index);
            return this;
        }
    }
}

