/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.websocket;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.websocket.WsSession;
import io.helidon.websocket.WsUpgradeException;
import java.util.Optional;

public interface WsListener {
    default public void onMessage(WsSession session, String text, boolean last) {
    }

    default public void onMessage(WsSession session, BufferData buffer, boolean last) {
    }

    default public void onPing(WsSession session, BufferData buffer) {
    }

    default public void onPong(WsSession session, BufferData buffer) {
    }

    default public void onClose(WsSession session, int status, String reason) {
    }

    default public void onError(WsSession session, Throwable t) {
    }

    default public void onOpen(WsSession session) {
    }

    default public Optional<Headers> onHttpUpgrade(HttpPrologue prologue, Headers headers) throws WsUpgradeException {
        return Optional.empty();
    }
}

