/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.context.Context;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.Routing;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfigBlueprint;
import io.helidon.webserver.WebServerConfigSupport;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.spi.ServerFeature;
import io.helidon.webserver.spi.ServerFeatureProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.WebServerConfigBlueprint")
public interface WebServerConfig
extends WebServerConfigBlueprint,
Prototype.Api,
ListenerConfig {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebServerConfig instance) {
        return (Builder)WebServerConfig.builder().from(instance);
    }

    public static WebServerConfig create(Config config) {
        return ((Builder)WebServerConfig.builder().config(config)).buildPrototype();
    }

    public static WebServerConfig create() {
        return WebServerConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, WebServerConfig>
    implements io.helidon.common.Builder<Builder, WebServer> {
        private Builder() {
        }

        public WebServerConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.WebServerConfigImpl(this);
        }

        public WebServer build() {
            return WebServer.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends WebServerConfig>
    extends ListenerConfig.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<ServerFeature> features = new ArrayList<ServerFeature>();
        private final Map<String, ListenerConfig> sockets = new LinkedHashMap<String, ListenerConfig>();
        private final Map<String, List<io.helidon.common.Builder<?, ? extends Routing>>> namedRoutings = new LinkedHashMap();
        private boolean featuresDiscoverServices = true;
        private boolean isFeaturesMutated;
        private boolean shutdownHook = true;
        private Config config;
        private Context serverContext;

        protected BuilderBase() {
        }

        public BUILDER from(WebServerConfig prototype) {
            super.from(prototype);
            this.shutdownHook(prototype.shutdownHook());
            this.addSockets(prototype.sockets());
            this.addNamedRoutings(prototype.namedRoutings());
            if (!this.isFeaturesMutated) {
                this.features.clear();
            }
            this.addFeatures(prototype.features());
            this.featuresDiscoverServices = false;
            this.serverContext(prototype.serverContext());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            this.shutdownHook(builder.shutdownHook());
            this.addSockets(builder.sockets);
            this.addNamedRoutings(builder.namedRoutings);
            if (this.isFeaturesMutated) {
                if (builder.isFeaturesMutated) {
                    this.addFeatures(builder.features);
                }
            } else {
                this.features.clear();
                this.addFeatures(builder.features);
            }
            this.featuresDiscoverServices = builder.featuresDiscoverServices;
            builder.serverContext().ifPresent(this::serverContext);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER routing(String socket, Consumer<HttpRouting.Builder> consumer) {
            WebServerConfigSupport.CustomMethods.routing(this, socket, consumer);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER routing(String socket, HttpRouting.Builder routing) {
            WebServerConfigSupport.CustomMethods.routing(this, socket, routing);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            super.config(config);
            config.get("shutdown-hook").as(Boolean.class).ifPresent(this::shutdownHook);
            config.get("sockets").asNodeList().ifPresent(nodes -> nodes.forEach(node -> this.sockets.put((String)node.get("name").asString().orElse((Object)node.name()), (ListenerConfig)node.map(ListenerConfig::create).get())));
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER shutdownHook(boolean shutdownHook) {
            this.shutdownHook = shutdownHook;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sockets(Map<? extends String, ? extends ListenerConfig> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.clear();
            this.sockets.putAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSockets(Map<? extends String, ? extends ListenerConfig> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.putAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putSocket(String key, ListenerConfig socket) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(socket);
            this.sockets.put(key, socket);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putSocket(String key, Consumer<ListenerConfig.Builder> consumer) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(consumer);
            ListenerConfig.Builder builder = ListenerConfig.builder();
            consumer.accept(builder);
            this.putSocket(key, builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER featuresDiscoverServices(boolean discoverServices) {
            this.featuresDiscoverServices = discoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER features(List<? extends ServerFeature> features) {
            Objects.requireNonNull(features);
            this.isFeaturesMutated = true;
            this.features.clear();
            this.features.addAll(features);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addFeatures(List<? extends ServerFeature> features) {
            Objects.requireNonNull(features);
            this.isFeaturesMutated = true;
            this.features.addAll(features);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addFeature(ServerFeature feature) {
            Objects.requireNonNull(feature);
            this.features.add(feature);
            this.isFeaturesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearServerContext() {
            this.serverContext = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serverContext(Context serverContext) {
            Objects.requireNonNull(serverContext);
            this.serverContext = serverContext;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serverContext(Consumer<Context.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Context.Builder builder = Context.builder();
            consumer.accept(builder);
            this.serverContext(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean shutdownHook() {
            return this.shutdownHook;
        }

        public Map<String, ListenerConfig> sockets() {
            return this.sockets;
        }

        public Map<String, List<io.helidon.common.Builder<?, ? extends Routing>>> namedRoutings() {
            return this.namedRoutings;
        }

        public List<ServerFeature> features() {
            return this.features;
        }

        public Optional<Context> serverContext() {
            return Optional.ofNullable(this.serverContext);
        }

        @Override
        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        @Override
        public String toString() {
            return "WebServerConfigBuilder{shutdownHook=" + this.shutdownHook + ",sockets=" + String.valueOf(this.sockets) + ",namedRoutings=" + String.valueOf(this.namedRoutings) + ",features=" + String.valueOf(this.features) + ",serverContext=" + String.valueOf(this.serverContext) + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
            Config config = this.config == null ? Config.empty() : this.config;
            HelidonServiceLoader serviceLoader = HelidonServiceLoader.create(ServiceLoader.load(ServerFeatureProvider.class));
            this.addFeatures(this.discoverServices(config, "features", serviceLoader, ServerFeatureProvider.class, ServerFeature.class, this.featuresDiscoverServices, this.features));
            new WebServerConfigSupport.ServerConfigDecorator().decorate(this);
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
        }

        BUILDER namedRoutings(Map<? extends String, List<io.helidon.common.Builder<?, ? extends Routing>>> namedRoutings) {
            Objects.requireNonNull(namedRoutings);
            this.namedRoutings.clear();
            this.namedRoutings.putAll(namedRoutings);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER addNamedRoutings(Map<? extends String, List<io.helidon.common.Builder<?, ? extends Routing>>> namedRoutings) {
            Objects.requireNonNull(namedRoutings);
            this.namedRoutings.putAll(namedRoutings);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER addNamedRouting(String key, io.helidon.common.Builder<?, ? extends Routing> namedRouting) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(namedRouting);
            this.namedRoutings.compute(key, (k, v) -> {
                v = v == null ? new ArrayList<io.helidon.common.Builder>() : new ArrayList(v);
                v.add(namedRouting);
                return v;
            });
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER addNamedRoutings(String key, List<io.helidon.common.Builder<?, ? extends Routing>> namedRoutings) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(namedRoutings);
            this.namedRoutings.compute(key, (k, v) -> {
                v = v == null ? new ArrayList() : new ArrayList(v);
                v.addAll(namedRoutings);
                return v;
            });
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER putNamedRouting(String key, List<io.helidon.common.Builder<?, ? extends Routing>> namedRouting) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(namedRouting);
            this.namedRoutings.put(key, List.copyOf(namedRouting));
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER serverContext(Optional<? extends Context> serverContext) {
            Objects.requireNonNull(serverContext);
            this.serverContext = serverContext.map(Context.class::cast).orElse(this.serverContext);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class WebServerConfigImpl
        extends ListenerConfig.BuilderBase.ListenerConfigImpl
        implements WebServerConfig,
        Supplier<WebServer> {
            private final boolean shutdownHook;
            private final List<ServerFeature> features;
            private final Map<String, ListenerConfig> sockets;
            private final Map<String, List<io.helidon.common.Builder<?, ? extends Routing>>> namedRoutings;
            private final Optional<Context> serverContext;

            protected WebServerConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.shutdownHook = builder.shutdownHook();
                this.sockets = Collections.unmodifiableMap(new LinkedHashMap<String, ListenerConfig>(builder.sockets()));
                this.namedRoutings = Collections.unmodifiableMap(new LinkedHashMap(builder.namedRoutings()));
                this.features = List.copyOf(builder.features());
                this.serverContext = builder.serverContext();
            }

            public WebServer build() {
                return WebServer.create(this);
            }

            @Override
            public WebServer get() {
                return this.build();
            }

            @Override
            public boolean shutdownHook() {
                return this.shutdownHook;
            }

            @Override
            public Map<String, ListenerConfig> sockets() {
                return this.sockets;
            }

            @Override
            public Map<String, List<io.helidon.common.Builder<?, ? extends Routing>>> namedRoutings() {
                return this.namedRoutings;
            }

            @Override
            public List<ServerFeature> features() {
                return this.features;
            }

            @Override
            public Optional<Context> serverContext() {
                return this.serverContext;
            }

            @Override
            public String toString() {
                return "WebServerConfig{shutdownHook=" + this.shutdownHook + ",sockets=" + String.valueOf(this.sockets) + ",namedRoutings=" + String.valueOf(this.namedRoutings) + ",features=" + String.valueOf(this.features) + ",serverContext=" + String.valueOf(this.serverContext) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WebServerConfig)) {
                    return false;
                }
                WebServerConfig other = (WebServerConfig)o;
                return super.equals(other) && this.shutdownHook == other.shutdownHook() && Objects.equals(this.sockets, other.sockets()) && Objects.equals(this.namedRoutings, other.namedRoutings()) && Objects.equals(this.features, other.features()) && Objects.equals(this.serverContext, other.serverContext());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.shutdownHook, this.sockets, this.namedRoutings, this.features, this.serverContext);
            }
        }
    }
}

