/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.http.PathMatcher;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.Route;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRouteImpl;
import java.util.Objects;
import java.util.function.Predicate;

public interface HttpRoute
extends Route {
    public static Builder builder() {
        return new Builder();
    }

    public PathMatchers.MatchResult accepts(HttpPrologue var1);

    public Handler handler();

    public static class Builder
    implements io.helidon.common.Builder<Builder, HttpRoute> {
        private Predicate<Method> methodPredicate = Method.predicate((Method[])new Method[0]);
        private PathMatcher pathMatcher = PathMatchers.any();
        private Handler handler;

        private Builder() {
        }

        public HttpRoute build() {
            Objects.requireNonNull(this.handler, "Handler must be provided");
            return new HttpRouteImpl(this);
        }

        public Builder methods(Method ... methods) {
            return this.methods((Predicate<Method>)Method.predicate((Method[])methods));
        }

        public Builder methods(Predicate<Method> methodPredicate) {
            this.methodPredicate = methodPredicate;
            return this;
        }

        public Builder path(String pathPattern) {
            return this.path(PathMatchers.create((String)pathPattern));
        }

        public Builder path(PathMatcher pathMatcher) {
            this.pathMatcher = pathMatcher;
            return this;
        }

        public Builder handler(Handler handler) {
            this.handler = handler;
            return this;
        }

        Predicate<Method> methodPredicate() {
            return this.methodPredicate;
        }

        PathMatcher pathPredicate() {
            return this.pathMatcher;
        }

        Handler handler() {
            return this.handler;
        }
    }
}

