/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.socket.PeerInfo;
import io.helidon.common.socket.PlainSocket;
import io.helidon.common.socket.SocketWriter;
import io.helidon.common.socket.TlsSocket;
import io.helidon.common.task.InterruptableTask;
import io.helidon.common.tls.Tls;
import io.helidon.http.HttpException;
import io.helidon.http.RequestException;
import io.helidon.webserver.CloseConnectionException;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.ConnectionProviders;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.ListenerContext;
import io.helidon.webserver.ProxyProtocolData;
import io.helidon.webserver.ProxyProtocolHandler;
import io.helidon.webserver.Router;
import io.helidon.webserver.spi.ServerConnection;
import io.helidon.webserver.spi.ServerConnectionSelector;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import javax.net.ssl.SSLSocket;

class ConnectionHandler
implements InterruptableTask<Void>,
ConnectionContext {
    private static final System.Logger LOGGER = System.getLogger(ConnectionHandler.class.getName());
    private final ListenerContext listenerContext;
    private final Semaphore connectionSemaphore;
    private final Semaphore requestSemaphore;
    private final ConnectionProviders connectionProviders;
    private final List<ServerConnectionSelector> providerCandidates;
    private final Map<String, ServerConnection> activeConnections;
    private final Socket socket;
    private final String serverChannelId;
    private final Router router;
    private final Tls tls;
    private final ListenerConfig listenerConfig;
    private ServerConnection connection;
    private HelidonSocket helidonSocket;
    private DataReader reader;
    private SocketWriter writer;
    private ProxyProtocolData proxyProtocolData;

    ConnectionHandler(ListenerContext listenerContext, Semaphore connectionSemaphore, Semaphore requestSemaphore, ConnectionProviders connectionProviders, Map<String, ServerConnection> activeConnections, Socket socket, String serverChannelId, Router router, Tls tls) {
        this.listenerContext = listenerContext;
        this.connectionSemaphore = connectionSemaphore;
        this.requestSemaphore = requestSemaphore;
        this.connectionProviders = connectionProviders;
        this.providerCandidates = connectionProviders.providerCandidates();
        this.activeConnections = activeConnections;
        this.socket = socket;
        this.serverChannelId = serverChannelId;
        this.router = router;
        this.tls = tls;
        this.listenerConfig = listenerContext.config();
    }

    public boolean canInterrupt() {
        InterruptableTask task;
        ServerConnection serverConnection = this.connection;
        return serverConnection instanceof InterruptableTask && (task = (InterruptableTask)serverConnection).canInterrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        String channelId = "0x" + HexFormat.of().toHexDigits(System.identityHashCode(this.socket));
        if (this.listenerConfig.enableProxyProtocol()) {
            ProxyProtocolHandler handler = new ProxyProtocolHandler(this.socket, channelId);
            this.proxyProtocolData = handler.get();
        }
        try {
            if (this.tls.enabled()) {
                SSLSocket sslSocket = (SSLSocket)this.socket;
                sslSocket.setHandshakeApplicationProtocolSelector((sslEngine, list) -> {
                    for (String protocolId : list) {
                        if (!this.connectionProviders.supportedApplicationProtocols().contains(protocolId)) continue;
                        return protocolId;
                    }
                    return null;
                });
                sslSocket.startHandshake();
                this.helidonSocket = TlsSocket.server((SSLSocket)sslSocket, (String)channelId, (String)this.serverChannelId);
            } else {
                this.helidonSocket = PlainSocket.server((Socket)this.socket, (String)channelId, (String)this.serverChannelId);
            }
            this.reader = new DataReader((Supplier)this.helidonSocket);
            this.writer = SocketWriter.create((ExecutorService)this.listenerContext.executor(), (HelidonSocket)this.helidonSocket, (int)this.listenerContext.config().writeQueueLength());
        }
        catch (Exception e) {
            RuntimeException re;
            throw e instanceof RuntimeException ? (re = (RuntimeException)e) : new RuntimeException(e);
        }
        String socketsId = this.helidonSocket.socketId() + " " + this.helidonSocket.childSocketId();
        Thread.currentThread().setName("[" + socketsId + "] WebServer socket");
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            this.helidonSocket.log(LOGGER, System.Logger.Level.DEBUG, "accepted socket from %s:%d", new Object[]{this.helidonSocket.remotePeer().host(), this.helidonSocket.remotePeer().port()});
        }
        try {
            if (this.helidonSocket.protocolNegotiated()) {
                this.connection = this.connectionProviders.byApplicationProtocol(this.helidonSocket.protocol()).connection(this);
            }
            if (this.connection == null) {
                this.connection = this.identifyConnection();
            }
            if (this.connection == null) {
                throw new CloseConnectionException("No suitable connection provider");
            }
            this.activeConnections.put(socketsId, this.connection);
            this.connection.handle(this.requestSemaphore);
        }
        catch (RequestException e) {
            this.helidonSocket.log(LOGGER, System.Logger.Level.WARNING, "escaped Request exception", (Throwable)e, new Object[0]);
        }
        catch (HttpException e) {
            this.helidonSocket.log(LOGGER, System.Logger.Level.WARNING, "escaped HTTP exception", (Throwable)e, new Object[0]);
        }
        catch (CloseConnectionException e) {
            this.helidonSocket.log(LOGGER, System.Logger.Level.TRACE, "connection close requested", (Throwable)e, new Object[0]);
        }
        catch (UncheckedIOException e) {
            this.helidonSocket.log(LOGGER, System.Logger.Level.TRACE, "received I/O exception", (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            this.helidonSocket.log(LOGGER, System.Logger.Level.WARNING, "unexpected exception", (Throwable)e, new Object[0]);
        }
        finally {
            this.connectionSemaphore.release();
            this.activeConnections.remove(socketsId);
            this.writer.close();
            this.closeChannel();
        }
        this.helidonSocket.log(LOGGER, System.Logger.Level.DEBUG, "socket closed", new Object[0]);
    }

    public PeerInfo remotePeer() {
        return this.helidonSocket.remotePeer();
    }

    public PeerInfo localPeer() {
        return this.helidonSocket.localPeer();
    }

    public boolean isSecure() {
        return this.helidonSocket.isSecure();
    }

    public String socketId() {
        return this.helidonSocket.socketId();
    }

    public String childSocketId() {
        return this.helidonSocket.childSocketId();
    }

    @Override
    public ListenerContext listenerContext() {
        return this.listenerContext;
    }

    @Override
    public ExecutorService executor() {
        return this.listenerContext.executor();
    }

    @Override
    public DataWriter dataWriter() {
        return this.writer;
    }

    @Override
    public DataReader dataReader() {
        return this.reader;
    }

    @Override
    public Router router() {
        return this.router;
    }

    @Override
    public Optional<ProxyProtocolData> proxyProtocolData() {
        return Optional.ofNullable(this.proxyProtocolData);
    }

    private ServerConnection identifyConnection() {
        if (this.providerCandidates.size() == 1) {
            return this.providerCandidates.getFirst().connection(this);
        }
        try {
            this.reader.ensureAvailable();
        }
        catch (DataReader.InsufficientDataAvailableException e) {
            throw new CloseConnectionException("No data available", e);
        }
        BufferData currentBuffer = this.reader.getBuffer(this.reader.available());
        while (true) {
            Iterator<ServerConnectionSelector> iterator;
            if (!(iterator = this.providerCandidates.iterator()).hasNext()) {
                this.helidonSocket.log(LOGGER, System.Logger.Level.DEBUG, "Could not find a suitable connection provider. initial connection buffer (may be empty if no providers exist):\n%s", new Object[]{currentBuffer.debugDataHex(false)});
                return null;
            }
            while (iterator.hasNext()) {
                ServerConnectionSelector candidate = iterator.next();
                int expectedBytes = candidate.bytesToIdentifyConnection();
                if (expectedBytes != 0 && expectedBytes >= currentBuffer.available()) continue;
                ServerConnectionSelector.Support supports = candidate.supports(currentBuffer);
                switch (supports) {
                    case SUPPORTED: {
                        return candidate.connection(this);
                    }
                    case UNSUPPORTED: {
                        iterator.remove();
                        break;
                    }
                    case UNKNOWN: {
                        if (expectedBytes == 0) break;
                        iterator.remove();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown support (" + String.valueOf((Object)supports) + ") returned from provider " + candidate.getClass().getName());
                    }
                }
                currentBuffer.rewind();
            }
            if (this.providerCandidates.isEmpty()) {
                this.helidonSocket.log(LOGGER, System.Logger.Level.DEBUG, "Could not find a suitable connection provider. initial connection buffer (may be empty if no providers exist):\n%s", new Object[]{currentBuffer.debugDataHex(true)});
                return null;
            }
            currentBuffer = this.reader.getBuffer(this.reader.available() + 1);
        }
    }

    private void closeChannel() {
        try {
            this.helidonSocket.close();
        }
        catch (Throwable e) {
            this.helidonSocket.log(LOGGER, System.Logger.Level.TRACE, "Failed to close socket on connection close", e, new Object[0]);
        }
    }
}

