/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Weights;
import io.helidon.http.DirectHandler;
import io.helidon.http.HttpException;
import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.http.NotFoundException;
import io.helidon.http.PathMatcher;
import io.helidon.http.RequestException;
import io.helidon.http.Status;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerLifecycle;
import io.helidon.webserver.http.ErrorHandler;
import io.helidon.webserver.http.ErrorHandlers;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.Filters;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRoutingFeature;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.RouteCrawler;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http.RoutingResponse;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServiceRoute;
import io.helidon.webserver.http.ServiceRules;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class HttpRouting
implements Routing,
Prototype.Api {
    private static final System.Logger LOGGER = System.getLogger(HttpRouting.class.getName());
    private static final HttpRouting EMPTY = (HttpRouting)HttpRouting.builder().build();
    private final Filters filters;
    private final ServiceRoute rootRoute;
    private final List<HttpFeature> features;
    private final int maxReRouteCount;
    private final HttpSecurity security;

    private HttpRouting(RealBuilder builder) {
        ErrorHandlers errorHandlers = ErrorHandlers.create(builder.errorHandlers);
        this.filters = Filters.create(errorHandlers, List.copyOf(builder.filters));
        this.rootRoute = builder.rootRules.build();
        this.features = List.copyOf(builder.features);
        this.maxReRouteCount = builder.maxReRouteCount;
        this.security = builder.security;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static HttpRouting create() {
        return (HttpRouting)HttpRouting.builder().route(HttpRoute.builder().handler((req, res) -> res.send("Helidon WebServer works!")).build()).build();
    }

    public static HttpRouting empty() {
        return EMPTY;
    }

    public void route(ConnectionContext ctx, RoutingRequest request, RoutingResponse response) {
        RoutingExecutor routingExecutor = new RoutingExecutor(ctx, this.rootRoute, request, response, this.maxReRouteCount);
        this.filters.filter(ctx, request, response, routingExecutor);
    }

    @Override
    public void beforeStart() {
        this.filters.beforeStart();
        this.rootRoute.beforeStart();
        this.features.forEach(ServerLifecycle::beforeStart);
    }

    @Override
    public void afterStop() {
        this.filters.afterStop();
        this.rootRoute.afterStop();
        this.features.forEach(ServerLifecycle::afterStop);
    }

    public HttpSecurity security() {
        return this.security;
    }

    private static final class RealBuilder
    implements Builder {
        private final List<Filter> filters = new ArrayList<Filter>();
        private final Map<Class<? extends Throwable>, ErrorHandler<?>> errorHandlers = new IdentityHashMap();
        private final ServiceRules rootRules = new ServiceRules();
        private final List<HttpFeature> features;
        private HttpSecurity security;
        private int maxReRouteCount;

        private RealBuilder(List<HttpFeature> features, HttpSecurity security, int maxReRouteCount) {
            this.features = new ArrayList<HttpFeature>(features);
            this.security = security;
            this.maxReRouteCount = maxReRouteCount;
        }

        public HttpRouting build() {
            throw new UnsupportedOperationException("This builder is internal and never built");
        }

        @Override
        public Builder register(HttpService ... service) {
            this.rootRules.register(service);
            return this;
        }

        @Override
        public Builder register(String pathPattern, HttpService ... service) {
            this.rootRules.register(pathPattern, service);
            return this;
        }

        @Override
        public Builder route(HttpRoute route) {
            this.rootRules.route(route);
            return this;
        }

        @Override
        public Builder addFilter(Filter filter) {
            this.filters.add(filter);
            return this;
        }

        @Override
        public Builder addFeature(Supplier<? extends HttpFeature> feature) {
            HttpFeature it = feature.get();
            this.features.add(it);
            it.setup(this);
            return this;
        }

        @Override
        public <T extends Throwable> Builder error(Class<T> exceptionClass, ErrorHandler<? super T> handler) {
            this.errorHandlers.put(exceptionClass, handler);
            return this;
        }

        @Override
        public Builder maxReRouteCount(int maxReRouteCount) {
            this.maxReRouteCount = maxReRouteCount;
            return this;
        }

        @Override
        public Builder security(HttpSecurity security) {
            this.security = security;
            return this;
        }

        @Override
        public Builder copy() {
            throw new UnsupportedOperationException("This builder should only be used internally by Helidon and never copied");
        }
    }

    static class BuilderImpl
    implements Builder {
        private final List<HttpFeature> features = new ArrayList<HttpFeature>();
        private final HttpRoutingFeature mainRouting = new HttpRoutingFeature();
        private HttpSecurity security = HttpSecurity.create();
        private int maxReRouteCount = 10;

        private BuilderImpl() {
        }

        private BuilderImpl(List<HttpFeature> features, HttpRoutingFeature mainRouting, HttpSecurity security, int maxReroute) {
            this.features.addAll(features);
            this.mainRouting.copyFrom(mainRouting);
            this.security = security;
            this.maxReRouteCount = maxReroute;
        }

        public HttpRouting build() {
            this.features.add(this.mainRouting);
            Weights.sort(this.features);
            RealBuilder realBuilder = new RealBuilder(this.features, this.security, this.maxReRouteCount);
            for (HttpFeature feature : this.features) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Setting up feature: " + feature.getClass().getName());
                }
                feature.setup(realBuilder);
            }
            return new HttpRouting(realBuilder);
        }

        @Override
        public Builder register(HttpService ... service) {
            this.mainRouting.service(service);
            return this;
        }

        @Override
        public Builder register(String path, HttpService ... service) {
            this.mainRouting.service(path, service);
            return this;
        }

        @Override
        public Builder route(HttpRoute route) {
            this.mainRouting.route(route);
            return this;
        }

        @Override
        public Builder addFilter(Filter filter) {
            this.mainRouting.filter(filter);
            return this;
        }

        @Override
        public Builder addFeature(Supplier<? extends HttpFeature> feature) {
            HttpFeature httpFeature = feature.get();
            this.features.add(httpFeature);
            return this;
        }

        @Override
        public <T extends Throwable> Builder error(Class<T> exceptionClass, ErrorHandler<? super T> handler) {
            this.mainRouting.error(exceptionClass, handler);
            return this;
        }

        @Override
        public Builder maxReRouteCount(int maxReRouteCount) {
            this.maxReRouteCount = maxReRouteCount;
            return this;
        }

        @Override
        public Builder security(HttpSecurity security) {
            this.security = security;
            return this;
        }

        @Override
        public Builder copy() {
            return new BuilderImpl(this.features, this.mainRouting, this.security, this.maxReRouteCount);
        }
    }

    public static interface Builder
    extends HttpRules,
    io.helidon.common.Builder<Builder, HttpRouting> {
        @Override
        public Builder register(HttpService ... var1);

        @Override
        default public Builder register(Supplier<? extends HttpService> service) {
            HttpRules.super.register(service);
            return this;
        }

        @Override
        default public Builder register(Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2) {
            HttpRules.super.register(service1, service2);
            return this;
        }

        @Override
        default public Builder register(Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3) {
            HttpRules.super.register(service1, service2, service3);
            return this;
        }

        @Override
        default public Builder register(Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3, Supplier<? extends HttpService> service4) {
            HttpRules.super.register(service1, service2, service3, service4);
            return this;
        }

        @Override
        default public Builder register(Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3, Supplier<? extends HttpService> service4, Supplier<? extends HttpService> service5) {
            HttpRules.super.register(service1, service2, service3, service4, service5);
            return this;
        }

        @Override
        default public Builder register(List<Supplier<? extends HttpService>> services) {
            HttpRules.super.register(services);
            return this;
        }

        @Override
        public Builder register(String var1, HttpService ... var2);

        @Override
        default public Builder register(String pathPattern, Supplier<? extends HttpService> service) {
            HttpRules.super.register(pathPattern, service);
            return this;
        }

        @Override
        default public Builder register(String pathPattern, Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2) {
            HttpRules.super.register(pathPattern, service1, service2);
            return this;
        }

        @Override
        default public Builder register(String pathPattern, Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3) {
            HttpRules.super.register(pathPattern, service1, service2, service3);
            return this;
        }

        @Override
        default public Builder register(String pathPattern, Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3, Supplier<? extends HttpService> service4) {
            HttpRules.super.register(pathPattern, service1, service2, service3, service4);
            return this;
        }

        @Override
        default public Builder register(String pathPattern, Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3, Supplier<? extends HttpService> service4, Supplier<? extends HttpService> service5) {
            HttpRules.super.register(pathPattern, service1, service2, service3, service4, service5);
            return this;
        }

        @Override
        default public Builder register(String pathPattern, List<Supplier<? extends HttpService>> services) {
            HttpRules.super.register(pathPattern, services);
            return this;
        }

        @Override
        public Builder route(HttpRoute var1);

        @Override
        default public Builder route(Supplier<? extends HttpRoute> route) {
            return this.route(route.get());
        }

        @Override
        default public Builder route(Method method, String pathPattern, Handler handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().methods(method).path(pathPattern).handler(handler)));
        }

        @Override
        default public Builder route(Method method, PathMatcher pathMatcher, Handler handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().path(pathMatcher).methods(method).handler(handler)));
        }

        @Override
        default public Builder route(Predicate<Method> methodPredicate, PathMatcher pathMatcher, Handler handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().path(pathMatcher).methods(methodPredicate).handler(handler)));
        }

        @Override
        default public Builder route(Method method, Handler handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().methods(method).handler(handler)));
        }

        @Override
        default public Builder get(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.GET, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder get(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.GET, handler);
            }
            return this;
        }

        @Override
        default public Builder post(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.POST, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder post(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.POST, handler);
            }
            return this;
        }

        @Override
        default public Builder put(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.PUT, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder put(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.PUT, handler);
            }
            return this;
        }

        @Override
        default public Builder delete(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.DELETE, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder delete(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.DELETE, handler);
            }
            return this;
        }

        @Override
        default public Builder head(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.HEAD, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder head(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.HEAD, handler);
            }
            return this;
        }

        @Override
        default public Builder options(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.OPTIONS, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder options(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.OPTIONS, handler);
            }
            return this;
        }

        @Override
        default public Builder trace(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.TRACE, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder trace(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.TRACE, handler);
            }
            return this;
        }

        @Override
        default public Builder patch(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.PATCH, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder patch(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.PATCH, handler);
            }
            return this;
        }

        @Override
        default public Builder any(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route((Supplier)((Object)HttpRoute.builder().path(pathPattern).handler(handler)));
            }
            return this;
        }

        @Override
        default public Builder any(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route((Supplier)((Object)HttpRoute.builder().handler(handler)));
            }
            return this;
        }

        @Override
        default public Builder route(Method method, String pathPattern, Consumer<ServerRequest> handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().methods(method).path(pathPattern).handler(Handler.create(handler))));
        }

        @Override
        default public Builder route(Method method, String pathPattern, Function<ServerRequest, ?> handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().methods(method).path(pathPattern).handler(Handler.create(handler))));
        }

        @Override
        default public Builder route(Method method, String pathPattern, Supplier<?> handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().methods(method).path(pathPattern).handler(Handler.create(handler))));
        }

        public Builder addFilter(Filter var1);

        public Builder addFeature(Supplier<? extends HttpFeature> var1);

        public <T extends Throwable> Builder error(Class<T> var1, ErrorHandler<? super T> var2);

        public Builder maxReRouteCount(int var1);

        public Builder security(HttpSecurity var1);

        public Builder copy();
    }

    private static final class RoutingExecutor
    implements Callable<Void> {
        private final ConnectionContext ctx;
        private final RoutingRequest request;
        private final RoutingResponse response;
        private final ServiceRoute rootRoute;
        private final int maxReRouteCount;

        private RoutingExecutor(ConnectionContext ctx, ServiceRoute rootRoute, RoutingRequest request, RoutingResponse response, int maxReRouteCount) {
            this.ctx = ctx;
            this.rootRoute = rootRoute;
            this.request = request;
            this.response = response;
            this.maxReRouteCount = maxReRouteCount;
        }

        @Override
        public Void call() throws Exception {
            RoutingResult result = this.doRoute(this.ctx, this.request, this.response);
            if (result == RoutingResult.FINISH) {
                this.response.commit();
                return null;
            }
            if (result == RoutingResult.NONE) {
                throw new NotFoundException("Not Found");
            }
            int counter = 1;
            while (result == RoutingResult.ROUTE) {
                if (++counter == this.maxReRouteCount) {
                    LOGGER.log(System.Logger.Level.ERROR, "Rerouted more than " + this.maxReRouteCount + " times. Will not attempt further routing");
                    throw new HttpException("Too many reroutes", Status.INTERNAL_SERVER_ERROR_500, true);
                }
                result = this.doRoute(this.ctx, this.request, this.response);
            }
            if (result == RoutingResult.FINISH) {
                this.response.commit();
                return null;
            }
            throw new NotFoundException("Not Found");
        }

        private RoutingResult doRoute(ConnectionContext ctx, RoutingRequest request, RoutingResponse response) throws Exception {
            HttpPrologue prologue = request.prologue();
            RouteCrawler crawler = this.rootRoute.crawler(ctx, request);
            while (crawler.hasNext()) {
                response.resetRouting();
                RouteCrawler.CrawlerItem next = crawler.next();
                request.path(next.path());
                next.handler().handle(request, response);
                if (response.shouldReroute()) {
                    if (response.isSent()) {
                        LOGGER.log(System.Logger.Level.WARNING, "Request to " + String.valueOf(request.prologue()) + " in inconsistent state. Request to re-route, but response was already sent. Ignoring reroute.");
                        return RoutingResult.FINISH;
                    }
                    HttpPrologue newPrologue = response.reroutePrologue(prologue);
                    request.prologue(newPrologue);
                    response.resetRouting();
                    return RoutingResult.ROUTE;
                }
                if (response.isNexted()) {
                    if (!response.isSent()) continue;
                    LOGGER.log(System.Logger.Level.WARNING, "Request to " + String.valueOf(request.prologue()) + " in inconsistent state. Request to next, but response was already sent. Ignoring next().");
                    return RoutingResult.FINISH;
                }
                if (response.hasEntity()) {
                    return RoutingResult.FINISH;
                }
                LOGGER.log(System.Logger.Level.WARNING, "A route MUST call either send, reroute, or next on ServerResponse on the request thread. Neither of these was called for request: " + String.valueOf(request.prologue()) + "; Handler: " + String.valueOf(next.handler()));
                throw RequestException.builder().message("Internal Server Error").type(DirectHandler.EventType.INTERNAL_ERROR).build();
            }
            return RoutingResult.NONE;
        }
    }

    private static enum RoutingResult {
        ROUTE,
        FINISH,
        NONE;

    }
}

