/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.webserver.ProtocolConfigs;
import io.helidon.webserver.http1.Http1Config;
import io.helidon.webserver.http1.Http1ConnectionSelector;
import io.helidon.webserver.http1.Http1ConnectionSelectorConfig;
import io.helidon.webserver.http1.spi.Http1UpgradeProvider;
import io.helidon.webserver.http1.spi.Http1Upgrader;
import io.helidon.webserver.spi.ProtocolConfig;
import io.helidon.webserver.spi.ServerConnectionSelector;
import io.helidon.webserver.spi.ServerConnectionSelectorProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ServiceLoader;

public class Http1ConnectionProvider
implements ServerConnectionSelectorProvider<Http1Config> {
    static final String CONFIG_NAME = "http_1_1";

    @Deprecated
    public Http1ConnectionProvider() {
    }

    @Override
    public Class<Http1Config> protocolConfigType() {
        return Http1Config.class;
    }

    @Override
    public String protocolType() {
        return CONFIG_NAME;
    }

    @Override
    public ServerConnectionSelector create(String socketName, Http1Config config, ProtocolConfigs configs) {
        Http1ConnectionSelectorConfig.Builder builder = (Http1ConnectionSelectorConfig.Builder)Http1ConnectionSelector.builder().config(config);
        List providers = HelidonServiceLoader.create(ServiceLoader.load(Http1UpgradeProvider.class)).asList();
        LinkedHashMap<String, Http1Upgrader> upgraders = new LinkedHashMap<String, Http1Upgrader>();
        for (Http1UpgradeProvider upgradeProvider : providers) {
            List upgradeConfigs = configs.config(upgradeProvider.protocolType(), upgradeProvider.protocolConfigType());
            for (ProtocolConfig upgradeConfig : upgradeConfigs) {
                Http1Upgrader http1Upgrader = upgradeProvider.create(upgradeConfig, configs);
                upgraders.putIfAbsent(http1Upgrader.supportedProtocol(), http1Upgrader);
            }
        }
        return ((Http1ConnectionSelectorConfig.Builder)builder.addUpgraders(upgraders)).build();
    }
}

