/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.Builder;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.Router;
import io.helidon.webserver.Routing;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.spi.ServerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class ServerFeatureContextImpl
implements ServerFeature.ServerFeatureContext {
    private final WebServerConfig serverConfig;
    private final Map<String, ListenerBuildersImpl> socketToBuilders;
    private final Set<String> configuredSockets;

    private ServerFeatureContextImpl(WebServerConfig serverConfig, Map<String, ListenerBuildersImpl> socketToBuilders) {
        this.serverConfig = serverConfig;
        this.socketToBuilders = socketToBuilders;
        this.configuredSockets = socketToBuilders.keySet().stream().filter(Predicate.not("@default"::equals)).collect(Collectors.toSet());
    }

    static ServerFeatureContextImpl create(WebServerConfig serverConfig) {
        Map<String, List<Builder<?, ? extends Routing>>> routingMap = serverConfig.namedRoutings();
        Map<String, ListenerConfig> sockets = serverConfig.sockets();
        HttpRouting.Builder httpRouting = ServerFeatureContextImpl.defaultRouting(serverConfig);
        List<Builder<?, ? extends Routing>> routings = serverConfig.routings();
        HashMap<String, ListenerBuildersImpl> socketToBuilders = new HashMap<String, ListenerBuildersImpl>();
        socketToBuilders.put("@default", new ListenerBuildersImpl("@default", serverConfig, httpRouting, routings));
        sockets.forEach((socketName, listener) -> {
            ArrayList builders = new ArrayList(listener.routings());
            List existingBuilders = (List)routingMap.get(socketName);
            if (existingBuilders != null) {
                builders.addAll(existingBuilders);
            }
            HttpRouting.Builder listenerHttpRouting = null;
            for (Builder builder : builders) {
                HttpRouting.Builder httpBuilder;
                if (!(builder instanceof HttpRouting.Builder)) continue;
                listenerHttpRouting = httpBuilder = (HttpRouting.Builder)builder;
            }
            if (listenerHttpRouting == null) {
                listenerHttpRouting = listener.routing().orElseGet(HttpRouting::builder);
                builders.add(listenerHttpRouting);
            }
            socketToBuilders.put((String)socketName, new ListenerBuildersImpl((String)socketName, serverConfig, listenerHttpRouting, builders));
        });
        return new ServerFeatureContextImpl(serverConfig, socketToBuilders);
    }

    @Override
    public WebServerConfig serverConfig() {
        return this.serverConfig;
    }

    @Override
    public boolean socketExists(String socketName) {
        return "@default".equals(socketName) || this.configuredSockets.contains(socketName);
    }

    @Override
    public Set<String> sockets() {
        return this.configuredSockets;
    }

    @Override
    public ListenerBuildersImpl socket(String socketName) {
        return Optional.ofNullable(this.socketToBuilders.get(socketName)).orElseThrow(() -> new NoSuchElementException("There is no socket configuration for socket named \"" + socketName + "\""));
    }

    Router router() {
        return this.router("@default");
    }

    Router router(String socketName) {
        ListenerBuildersImpl listener = this.socket(socketName);
        boolean containsHttp = listener.routings.stream().anyMatch(it -> it instanceof HttpRouting.Builder);
        Router.Builder builder = Router.builder();
        if (!containsHttp) {
            builder.addRouting(listener.httpRouting());
        }
        return (Router)((Router.Builder)builder.update(it -> listener.routings().forEach(it::addRouting))).build();
    }

    private static HttpRouting.Builder defaultRouting(WebServerConfig serverConfig) {
        HttpRouting.Builder httpRouting = serverConfig.routing().orElse(null);
        if (httpRouting == null) {
            List<Builder<?, Routing>> routings = serverConfig.routings();
            for (Builder<?, ? extends Routing> builder : routings) {
                HttpRouting.Builder httpBuilder;
                if (!(builder instanceof HttpRouting.Builder)) continue;
                httpRouting = httpBuilder = (HttpRouting.Builder)builder;
            }
            if (httpRouting == null) {
                httpRouting = HttpRouting.builder();
            }
        }
        return httpRouting;
    }

    private static class ListenerBuildersImpl
    implements ServerFeature.SocketBuilders {
        private final ListenerConfig listenerConfig;
        private final HttpRouting.Builder httpRouting;
        private final List<Builder<?, ? extends Routing>> routings;
        private final ServerFeature.RoutingBuilders routingBuilders;

        ListenerBuildersImpl(String socketName, ListenerConfig listenerConfig, HttpRouting.Builder httpRouting, List<Builder<?, ? extends Routing>> routings) {
            this.listenerConfig = listenerConfig;
            this.httpRouting = httpRouting;
            this.routings = routings;
            this.routingBuilders = RoutingBuildersImpl.create(socketName, routings);
        }

        @Override
        public ListenerConfig listener() {
            return this.listenerConfig;
        }

        @Override
        public HttpRouting.Builder httpRouting() {
            return this.httpRouting;
        }

        @Override
        public ServerFeature.RoutingBuilders routingBuilders() {
            return this.routingBuilders;
        }

        List<Builder<?, ? extends Routing>> routings() {
            return this.routings;
        }
    }

    private static class RoutingBuildersImpl
    implements ServerFeature.RoutingBuilders {
        private final String socketName;
        private final Map<Class<?>, Object> buildersByType;

        RoutingBuildersImpl(String socketName, Map<Class<?>, Object> builders) {
            this.socketName = socketName;
            this.buildersByType = builders;
        }

        static ServerFeature.RoutingBuilders create(String socketName, List<Builder<?, ? extends Routing>> routings) {
            IdentityHashMap byType = new IdentityHashMap();
            for (Builder<?, Routing> builder : routings) {
                byType.put(builder.getClass(), builder);
            }
            return new RoutingBuildersImpl(socketName, byType);
        }

        @Override
        public boolean hasRouting(Class<?> builderType) {
            return this.buildersByType.containsKey(builderType);
        }

        @Override
        public <T extends Builder<T, ?>> T routingBuilder(Class<T> builderType) {
            Optional<Object> result = Optional.ofNullable(this.buildersByType.get(builderType));
            if (result.isPresent()) {
                return (T)((Builder)builderType.cast(result.get()));
            }
            throw new NoSuchElementException("There is no routing builder of type " + builderType.getName() + " available on socket \"" + this.socketName + "\"");
        }
    }
}

