/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import java.net.SocketOption;
import java.time.Duration;
import java.util.Map;

@Prototype.Blueprint
@Prototype.Configured
interface ConnectionConfigBlueprint {
    public static final String DEFAULT_READ_TIMEOUT_DURATION = "PT30S";
    public static final String DEFAULT_CONNECT_TIMEOUT_DURATION = "PT10S";
    public static final int DEFAULT_SO_BUFFER_SIZE = 32768;

    @Option.Configured
    @Option.Default(value={"PT30S"})
    public Duration readTimeout();

    @Option.Configured
    @Option.Default(value={"PT10S"})
    public Duration connectTimeout();

    @Option.Configured
    @Option.DefaultInt(value={32768})
    public int sendBufferSize();

    @Option.Configured
    @Option.DefaultInt(value={32768})
    public int receiveBufferSize();

    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean keepAlive();

    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean reuseAddress();

    @Option.Configured
    @Option.DefaultBoolean(value={false})
    public boolean tcpNoDelay();

    @Option.Singular
    public Map<SocketOption<?>, Object> socketOptions();
}

