/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.webserver.http1.Http1ConnectionListener;
import java.util.LinkedList;
import java.util.List;

final class Http1ConnectionListenerUtil {
    private Http1ConnectionListenerUtil() {
    }

    static Http1ConnectionListener toSingleListener(List<Http1ConnectionListener> sendFrameListeners) {
        if (sendFrameListeners.isEmpty()) {
            return NoOpFrameListener.INSTANCE;
        }
        if (sendFrameListeners.size() == 1) {
            return sendFrameListeners.get(0);
        }
        return new ListFrameListener(sendFrameListeners);
    }

    static List<Http1ConnectionListener> singleListenerToList(Http1ConnectionListener listener) {
        if (listener instanceof NoOpFrameListener) {
            return new LinkedList<Http1ConnectionListener>();
        }
        if (listener instanceof ListFrameListener) {
            ListFrameListener frameListener = (ListFrameListener)listener;
            return new LinkedList<Http1ConnectionListener>(frameListener.delegates);
        }
        LinkedList<Http1ConnectionListener> listeners = new LinkedList<Http1ConnectionListener>();
        listeners.add(listener);
        return listeners;
    }

    private static final class NoOpFrameListener
    implements Http1ConnectionListener {
        private static final NoOpFrameListener INSTANCE = new NoOpFrameListener();

        private NoOpFrameListener() {
        }
    }

    private static final class ListFrameListener
    implements Http1ConnectionListener {
        private final List<Http1ConnectionListener> delegates;

        ListFrameListener(List<Http1ConnectionListener> delegates) {
            this.delegates = delegates;
        }
    }
}

